package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Entity;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.channels.CIntranet.beans.XMLSerializable;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.utils.Users;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * Admin<br>
 * <br>
 * Cette classe gre les administrateurs<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class Admin extends AbstractAction {

    protected static Log log = LogFactory.getLog(Admin.class);
    
    private List admins = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public Admin(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche la liste des administrateurs
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Admin::init()");
        }
        DataControler data = new DataControler();
        try {
            admins = data.getAdmins();
        }
        catch(DataException e) {
            log.error("Admin::init() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        for(Iterator i = admins.iterator();i.hasNext();) {
            Entity tmp = (Entity)i.next();
            tmp.setName(Users.getUserDisplayName(tmp.getId()));
        }
        return Boolean.TRUE;
    }

    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche la liste des administrateurs
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("Admin::setXML()");
        }
        Collections.sort(admins);
        StringBuffer xml = new StringBuffer();
        xml.append("<admins>\n");
        for(Iterator i = admins.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</admins>\n");
        if(log.isDebugEnabled()) {
            log.debug("Admin::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        return Boolean.TRUE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Ajoute un nouvel administrateur
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean addinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Admin::addinit()");
        }
        String id = getRuntimeData().getParameter("id");
        
        if(id == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        
        if(id.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Le champs est obligatoire"), "admins");
            return Boolean.FALSE;
        }
        
        DataControler data = new DataControler();
        try {
            data.addAdmin(id);
        }
        catch(DataException e) {
            log.error("Admin::addinit() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admins");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "admins");        
        return Boolean.FALSE;
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Supprime un administrateur
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean delinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Admin::delinit()");
        }
        String id = runtimeData.getParameter("id");
        
        if(id == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        
        if(id.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admins");
            return Boolean.FALSE;
        }
        
        DataControler data = new DataControler();
        try {
            data.removeAdmin(id);
        }
        catch(DataException e) {
            log.error("Admin::delinit() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admins");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "admins");
        return Boolean.FALSE;
    }

}
