package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.CIntranet.beans.Entity;
import org.esupportail.portal.channels.CIntranet.beans.Grant;
import org.esupportail.portal.channels.CIntranet.beans.Group;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.channels.CIntranet.beans.XMLSerializable;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.channels.CIntranet.utils.UsersGroupsNames;
import org.esupportail.portal.utils.Groups;
import org.esupportail.portal.utils.channels.ActionParam;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * Permissions<br>
 * <br>
 * Cette classe prend en charge la gestion des permissions<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class Permissions extends AbstractAction {

    protected static Log log = LogFactory.getLog(Permissions.class);
    
    private List grants = null;
    private List ed_full = null;
    private List ed_val = null;
    private List aut_full = null;
    private List aut_mod = null;
    private List aut_new = null;
    private List groups = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public Permissions(MainChannel mainChannel) {
        super(mainChannel);
        ed_full = new ArrayList();
        ed_val = new ArrayList();
        aut_full = new ArrayList();
        aut_mod = new ArrayList();
        aut_new = new ArrayList();
    }

    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.ED_VAL;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche les permissions
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Permissions::init()");
        }
        DataControler data = new DataControler();
        try {
            grants = data.getGrants(folderid);
        }
        catch(DataException e) {
            log.error("Permissions::init() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
            return Boolean.FALSE;
        }
        List entities = new ArrayList();
        ed_full = new ArrayList();
        ed_val = new ArrayList();
        aut_full = new ArrayList();
        aut_mod = new ArrayList();
        aut_new = new ArrayList();
        groups = new ArrayList();
        for(Iterator i= grants.iterator();i.hasNext();) {
            Grant tmp = (Grant)i.next();
            entities.add(tmp.getGranted());
            switch(tmp.getLevel()) {
            	case Security.ED_FULL : ed_full.add(tmp);break;
            	case Security.ED_VAL : ed_val.add(tmp);break;
            	case Security.AUT_FULL : aut_full.add(tmp);break;
            	case Security.AUT_MOD : aut_mod.add(tmp);break;
            	case Security.AUT_NEW : aut_new.add(tmp);break;
            }
        }
        UsersGroupsNames.getNames(entities);
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche la liste des intranets accessibles
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("ViewFolder::setXML()");
        }
        
        Collections.sort(ed_full);
        Collections.sort(ed_val);
        Collections.sort(aut_full);
        Collections.sort(aut_mod);
        Collections.sort(aut_new);
        
        StringBuffer xml = new StringBuffer();
        xml.append("<ed_full>\n");
        for(Iterator i = ed_full.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</ed_full>\n");
        xml.append("<ed_val>\n");
        for(Iterator i = ed_val.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</ed_val>\n");
        xml.append("<aut_full>\n");
        for(Iterator i = aut_full.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</aut_full>\n");
        xml.append("<aut_mod>\n");
        for(Iterator i = aut_mod.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</aut_mod>\n");
        xml.append("<aut_new>\n");
        for(Iterator i = aut_new.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</aut_new>\n");
        if(log.isDebugEnabled()) {
            log.debug("ViewFolder::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        getXSLParameter().put("folder", folderid);
        getXSLParameter().put("user", userid);
        return Boolean.TRUE;
    }
    
    /**
     * Etape 4/4 du cyle de vie de la SubChannel
     * Positionne le titre SSL  utiliser
     * Override SubChannel.setOutput() method
     */
    public void setOutput() throws FrameWorkException {
        super.setOutput();
        if(level == Security.ED_FULL) {
            setXSL("full");
        }
        else {
            setXSL("val");
        }
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite l'ajout d'un utilisateur
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean adduserinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(log.isDebugEnabled()) {
            log.debug("Permissions::adduserinit()");
        }
        if(level != Security.ED_FULL) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "permissions", parameters);
            return Boolean.FALSE;
        }
        Object [] res = getMainChannel().getServantResults();
		if(res == null || res.length != 1) {
			getRuntimeData().setParameter("folder", folderid);
			getMainChannel().redirect(getRuntimeData(), "permissions");
			return Boolean.FALSE;
		}
		Personne selected = (Personne)res[0];
		try {
			if(!Security.isIntranetAccessible(selected.getIdentifiant(), intranet.getId())) {
			    Hashtable parameters = new Hashtable();
	            parameters.put("folder", folderid);
	            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Cet utilisateur n'est pas membre de cet intranet"), "permissions", parameters);
	            return Boolean.FALSE;
			}
		}
		catch(SecurityException e) {
		    log.error("Permissions::adduserinit() : SecurityException :\n" + e);
		    Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "permissions", parameters);
            return Boolean.FALSE;
		}
		Grant grant = new Grant();
		grant.setExtended(false);
		grant.setNotification(true);
		grant.setFolderid(folderid);
		ActionParam param = (ActionParam)getMainChannel().getCurrentAction().getParams().get("type");
		String level = param.getValue(); 
		grant.setLevel(new Integer(level).intValue());
		Entity ent = new User();
		ent.setId(selected.getIdentifiant());
		grant.setGranted(ent);
		DataControler data = new DataControler();
		try {
		    data.addGrant(grant);
		}
		catch(DataException e) {
		    log.error("Permissions::adduserinit() : DataException :\n" + e);
		    Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "permissions", parameters);
            return Boolean.FALSE;
		}
		getRuntimeData().setParameter("folder", folderid);
		getMainChannel().redirect(getRuntimeData(), "permissions");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite l'ajout d'un groupe
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean addgroupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(log.isDebugEnabled()) {
            log.debug("Permissions::addgroupinit()");
        }
        if(level != Security.ED_FULL) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "permissions", parameters);
            return Boolean.FALSE;
        }
        String [] ids = getRuntimeData().getParameterValues("selected");
		if(ids == null || ids.length == 0) {
			getRuntimeData().setParameter("folder", folderid);
			getMainChannel().redirect(getRuntimeData(), "permissions");
			return Boolean.FALSE;
		}
		Vector messages = new Vector();
		for(int i=0;i<ids.length;i++) {
		    String id = ids[i];
		    Grant grant = new Grant();
			grant.setExtended(false);
			grant.setNotification(false);
			grant.setFolderid(folderid);
			ActionParam param = (ActionParam)getMainChannel().getCurrentAction().getParams().get("type");
			String level = param.getValue(); 
			grant.setLevel(new Integer(level).intValue());
			Entity ent = new Group();
			ent.setId(id);
			UsersGroupsNames.getName(ent);
			grant.setGranted(ent);
			DataControler data = new DataControler();
			try {
			    data.addGrant(grant);
			}
			catch(DataException e) {
			    log.error("Permissions::addgroupinit() : DataException :\n" + e);
			    messages.add(new MessageBean("Groupe " + ent.getName() + " : " + e.getMessage()));
			}
		}
		if(!messages.isEmpty()) {
		    Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), messages, "permissions", parameters);
            return Boolean.FALSE;
		}
		getRuntimeData().setParameter("folder", folderid);
		getMainChannel().redirect(getRuntimeData(), "permissions");
        return Boolean.FALSE;
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche les groupes
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean groupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Permissions::groupinit()");
        }
        DataControler data = new DataControler();
        List entities = null;
        try {
            entities = data.getIntranetEntities(intranet.getId());
        }
        catch(DataException e) {
            log.error("Permissions::groupinit() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
            return Boolean.FALSE;
        }
        groups = new ArrayList();
        Group tlm = new Group();
        tlm.setId("_EVERYBODY");
        groups.add(tlm);
        for(Iterator i = entities.iterator();i.hasNext();) {
            Entity tmp = (Entity)i.next();
            if(tmp instanceof Group) {
                groups.add(tmp);
            }
        }
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche les groupes
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean groupxml() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("ViewFolder::groupxml()");
        }
        UsersGroupsNames.getNames(groups);
        Collections.sort(groups);
        StringBuffer xml = new StringBuffer();
        for(Iterator i = groups.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        setXML(xml.toString());
        ActionParam action = (ActionParam)getMainChannel().getCurrentAction().getParams().get("action");
        ActionParam servant = (ActionParam)getMainChannel().getCurrentAction().getParams().get("servant");
        getXSLParameter().put("action", action.getValue());
        getXSLParameter().put("servant", servant.getValue());
        getXSLParameter().put("folder", folderid);
        return Boolean.TRUE;
    }
    
    /**
     * Etape 4/4 du cyle de vie de la SubChannel
     * Positionne le titre SSL  utiliser
     * Override SubChannel.setOutput() method
     */
    public void groupoutput() throws FrameWorkException {
        super.setOutput();
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Supprime un droit
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean delinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Permissions::delinit()");
        }
        if(level != Security.ED_FULL) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "permissions", parameters);
            return Boolean.FALSE;
        }
        String type = getRuntimeData().getParameter("type");
        String id = getRuntimeData().getParameter("id");
        String level = getRuntimeData().getParameter("level");
        if(type == null || id == null || level == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        Grant grant = new Grant();
        grant.setExtended(false);
        grant.setFolderid(folderid);
        grant.setLevel(new Integer(level).intValue());
        Entity ent = null;
        if(type.equals("user")) {
            ent = new User();
        }
        else {
            ent = new Group();
        }
        ent.setId(id);
        grant.setGranted(ent);
        DataControler data = new DataControler();
        try {
            data.removeGrant(grant);
        }
        catch(DataException e) {
            log.error("Permissions::delinit() : DataException :\n" + e);
		    Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "permissions", parameters);
            return Boolean.FALSE;
        }
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "permissions");
        return Boolean.FALSE;
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Ajoute ou supprime une notification
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean notinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Permissions::notinit()");
        }
        String notif = getRuntimeData().getParameter("notif");
        String level = getRuntimeData().getParameter("level");
        if(notif == null || level == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        Grant grant = new Grant();
        grant.setFolderid(folderid);
        grant.setLevel(new Integer(level).intValue());
        User user = new User();
        user.setId(userid);
        grant.setGranted(user);
        if(notif.equals("yes")) {
            grant.setNotification(true);
        }
        else {
            grant.setNotification(false);
        }
        DataControler data = new DataControler();
        try {
            data.setNotification(grant);
        }
        catch(DataException e) {
            log.error("Permissions::notinit() : DataException :\n" + e);
		    Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "permissions", parameters);
            return Boolean.FALSE;
        }
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "permissions");
        return Boolean.FALSE;
    }

    
    /**
     * Nettoyage du canal
     * Override Subchannel.clearChannel method
     */
    public void clearChannel() {
        super.clearChannel();
        ed_full = null;
        ed_val = null;
        aut_full = null;
        aut_mod = null;
        aut_new = null;
    }
}
