package org.esupportail.portal.channels.CIntranet.beans;

import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.jasig.portal.utils.XMLEscaper;

/**
 * DocumentLink<br>
 * <br>
 * Document de type lien<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class DocumentLink extends Document {
    
    private String url = "";
    
    /**
     * Constructeur
     */
    public DocumentLink() {
        super();
        setType(Document.LINK);
    }

    /**
     * Retourne l'URL
     * @return url L'URL
     */
    public String getUrl() {
        return url;
    }
    
    /**
     * Positionne l'URL
     * @param url L'URL
     */
    public void setUrl(String url) {
        this.url = url;
    }
    
    /**
     * Teste l'galit de deux documents
     * Override Object.equals() method
     * @param o Objet  tester
     */
    public boolean equals(Object o) {
        if(!(o instanceof DocumentLink)) {
            return false;
        }
        DocumentLink doc = (DocumentLink)o;
        return (getType() == doc.getType()) && getName().equals(doc.getName()) && getDescription().equals(doc.getDescription()) && getUrl().equals(doc.getUrl());
    }

    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<document type=\"link\" id=\"" + getId() + "\" folder=\"" + getFolderid() + "\" ");
        xml.append("name=\"" + XMLEscaper.escape(getName()) + "\" description=\"" + XMLEscaper.escape(getDescription()) + "\" ");
        xml.append("author=\"" + getAuthor() + "\" date=\"" + getDate() + "\" datetext=\"" + Date.formatDate(getDate()) + "\" ");
        xml.append("validity=\"" + getValidityDate() + "\" validitytext=\"" + Date.formatDate(getValidityDate()) + "\" ");
        xml.append("valid=\"" + isValid() + "\" visible=\"" + isVisible() + "\" modified=\"" + isPendingModification() + "\" ");
        xml.append("deleted=\"" + isPendingDeletion() + "\" url=\"" + getUrl() + "\" order=\"" + getOrder() + "\" ");
        xml.append("perimed=\"" + isPerimed() + "\" validityinput=\"" + getValidityInput() + "\" />\n");
        return xml.toString();
    }
}
