package org.esupportail.portal.channels.CIntranet.beans;

import java.util.Iterator;
import java.util.List;

import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * SearchResult<br>
 * <br>
 * Classe dfinissant le comportement d'un rsultat de recherche<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class SearchResult implements XMLSerializable {

    private List path = null;
    private Document document = null;
    
    /**
     * Constructeur
     */
    public SearchResult() {
        super();
    }
    
    /**
     * Retourne le chemin
     * @return path Le chemin
     */
    public List getPath() {
        return path;
    }
    
    /**
     * Positionne le chemin
     * @param path Le chemin
     */
    public void setPath(List path) {
        this.path = path;
    }
    
    /**
     * Retourne le document
     * @return doc Le document
     */
    public Document getDocument() {
        return document;
    }
    
    /**
     * Positionne le document
     * @param document Le document
     */
    public void setDocument(Document document) {
        this.document = document;
    }
    
    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<result>\n");
        xml.append("<path>\n");
        for(Iterator i = getPath().iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</path>\n");
        xml.append(getDocument().toXMLString());
        xml.append("</result>\n");
        return xml.toString();
    }
}
