package org.esupportail.portal.channels.CIntranet.cron;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.Grant;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.beans.SearchResult;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.NotificationControler;
import org.esupportail.portal.channels.CIntranet.filters.Filter;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.esupportail.portal.utils.Users;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.services.PersonDirectory;

/**
 * CRONNotification<br>
 * <br>
 * Cette classe prend en charge la notification par CRON<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class CRONNotification {
   
    private static String TEMPLATE_MAIL = "/properties/channels/org_esup/CIntranet/templates/template_mail.html";
    private static String TEMPLATE_DOC = "/properties/channels/org_esup/CIntranet/templates/template_doc.html";
    private static String CAS_URL_PROPERTY = "org.jasig.portal.security.provider.YaleCasContext.CasLoginUrl";
    private static String PORTAL_URL_PROPERTY = "org.jasig.portal.security.provider.YaleCasContext.PortalServiceUrl";
    
    /**
     * Constructeur
     */
    public CRONNotification() {
    }
    
    /**
     * Dmarre l'opration de notification
     */
    private void start() {
        NotificationControler not = new NotificationControler();
        List intranets = null;
        Map notifications = new HashMap();
        try {
            intranets = not.getIntranets();
            Collections.sort(intranets);
            for(Iterator i = intranets.iterator();i.hasNext();) {
                Intranet tmp = (Intranet)i.next();
                List documents = null;
                try {
                    documents = not.getInvalidDocuments(tmp.getId());
                }
                catch(DataException e) {
                    System.out.println("DataException :\n" + e);
                }
                Filter.documentFilter(documents, "", Security.ED_VAL);
                Collections.sort(documents);
                for(Iterator j = documents.iterator();j.hasNext();) {
                    Document doc = (Document)j.next();
                    List grants = null;
                    try {
                        grants = not.getGrants(doc.getFolderid());
                    }
                    catch(DataException e) {
                        System.out.println("DataException :\n" + e);
                    }
                    for(Iterator k = grants.iterator();k.hasNext();) {
                        Grant g = (Grant)k.next();
                        if(g.getLevel() > Security.AUT_FULL && g.isNotification() && g.getGranted() instanceof User) {
                            if(notifications.get(g.getGranted().getId()) != null) {
                                List list = (List)notifications.get(g.getGranted().getId());
                                SearchResult nd = new SearchResult();
                                nd.setDocument(doc);
                                try {
                                    nd.setPath(not.getFolderPath(doc.getFolderid()));
                                    list.add(nd);
                                }
                                catch(DataException e) {
                                    System.out.println("DataException :\n" + e);
                                }
                            }
                            else {
                                List docs = new ArrayList();
                                SearchResult nd = new SearchResult();
                                nd.setDocument(doc);
                                nd.setPath(not.getFolderPath(doc.getFolderid()));
                                docs.add(nd);
                                notifications.put(g.getGranted().getId(), docs);
                            }
                       }
                    }
                }
            }
            
        }
        catch(DataException e) {
            System.out.println("DataException :\n" + e);
        }
        notifie(notifications);
    }
    
    /**
     * Envoie les notifications
     * @param notifications La liste des notifications
     */
    private void notifie(Map notifications) {
        for(Iterator i = notifications.keySet().iterator();i.hasNext();) {
            String login = (String)i.next();
            String mail = getMailAddress(login);
            if(mail != null) {
                mail(mail, (List)notifications.get(login));
            }
        }
    }
    
    /**
     * Envoie un message lectronique
     * @param mail L'adresse du destinataire
     * @param documents La liste des documents  incorporer au mail
     */
    private void mail(String mail, List documents) {
        Properties props = System.getProperties();
		props.put("mail.smtp.host", Config.getInstance().getSMTP());
		Session session = Session.getDefaultInstance(props, null);
		MimeMessage message = new MimeMessage(session);
		try {
            message.setFrom(new InternetAddress(Config.getInstance().getFROM()));
            InternetAddress[] dest = new InternetAddress[1];
            dest[0] = new InternetAddress(mail);
            message.setReplyTo(dest);
            message.addRecipients(Message.RecipientType.TO, dest);
			message.setSubject("[INTRANET]");
			BodyPart messageBodyPart = new MimeBodyPart();
			messageBodyPart.setText(getTextForEmail(documents));
			messageBodyPart.setContent(getHTMLForEmail(documents), "text/html"); 
	
			Multipart multipart = new MimeMultipart();
			multipart.addBodyPart(messageBodyPart);
			message.setContent(multipart);
			Transport.send(message);
        } 
		catch (MessagingException e) {
	        System.out.println("MessagingException :\n" + e);
        }
    }
    
    /**
     * Construit le corps du message en plain/text
     * @param documents La liste des documents  incorporer
     * @return Le texte du message
     */
    private String getTextForEmail(List documents) {
        StringBuffer text = new StringBuffer();
        for(Iterator i = documents.iterator();i.hasNext();) {
            SearchResult tmp = (SearchResult)i.next();
            for(Iterator j = tmp.getPath().iterator();j.hasNext();) {
                Folder folder = (Folder)j.next();
                text.append(folder.getName());
                text.append(" > ");
            }
            text.append(tmp.getDocument().getName());
            text.append(" - ");
            text.append(tmp.getDocument().getDescription());
            text.append("\n");
        }
        return text.toString();
    }
    
    /**
     * Construit le corps du message en HTML
     * @param documents La liste des documents  incorporer
     * @return Le texte du message
     */
    private String getHTMLForEmail(List documents) {
  
        BufferedReader mail_reader = null;
        BufferedReader doc_reader = null;
        
        try {
            mail_reader = new BufferedReader(new FileReader(new File(CRONNotification.class.getResource(TEMPLATE_MAIL).getFile())));
            doc_reader = new BufferedReader(new FileReader(new File(CRONNotification.class.getResource(TEMPLATE_DOC).getFile())));
        }
        catch(FileNotFoundException e) {
            System.out.println("FileNotFoundException :\n" + e);
            return "";
        }
            
        StringBuffer mail = new StringBuffer();
        StringBuffer doc = new StringBuffer();
        String read;
        try {
            while((read = mail_reader.readLine()) != null) {
                mail.append(read);
                mail.append("\n");
            }
            while((read = doc_reader.readLine()) != null) {
                doc.append(read);
                doc.append("\n");
            }
        }
        catch(IOException e) {
            System.out.println("IOException :\n" + e);
            return "";
        }
        
        StringBuffer doc_lines = new StringBuffer();
        
        for(Iterator i = documents.iterator();i.hasNext();) {
            String doc_line = doc.toString();
            SearchResult tmp = (SearchResult)i.next();
            System.out.println(tmp.getDocument().toXMLString());
            StringBuffer path = new StringBuffer();
            for(Iterator j = tmp.getPath().iterator();j.hasNext();) {
                Folder folder = (Folder)j.next();
                path.append(folder.getName());
                path.append(" &gt; ");
            }
            doc_line = doc_line.replaceAll("\\$PATH\\$", path.toString());
            doc_line = doc_line.replaceAll("\\$NAME\\$", tmp.getDocument().getName());
            doc_line = doc_line.replaceAll("\\$DESCRIPTION\\$", tmp.getDocument().getDescription());
            doc_line = doc_line.replaceAll("\\$AUTHOR\\$", Users.getUserDisplayName(tmp.getDocument().getAuthor()));
            doc_line = doc_line.replaceAll("\\$DATE\\$", Date.formatDate(tmp.getDocument().getDate()));
            
            StringBuffer url = new StringBuffer();
            url.append(PropertiesManager.getProperty(CAS_URL_PROPERTY));
            url.append("?service=");
            url.append(PropertiesManager.getProperty(PORTAL_URL_PROPERTY));
            url.append("?uP_fname=");
            url.append(Config.getInstance().getChannelFunctionnalName());
            url.append("%26uP_args%3D");
            url.append("action%3Dviewdocument");
            url.append("%7Cintranet%3D" + tmp.getDocument().getIntranet());
            url.append("%7Cfolder%3D" + tmp.getDocument().getFolderid());
            url.append("%7Cid%3D" + tmp.getDocument().getId());
            doc_line = doc_line.replaceAll("\\$URL\\$", url.toString());
            
            doc_lines.append(doc_line);
        }
        return mail.toString().replaceAll("\\$TEMPLATE_DOC\\$", doc_lines.toString());
    }
    
    /**
     * Retourne l'adresse lectronique d'un utilisateur
     * @param login L'identifiant de l'utilisateur
     * @return L'adresse lectronique
     */
    private String getMailAddress(String login) {
	    Hashtable attributes = PersonDirectory.instance().getUserDirectoryInformation(login);
	    if(attributes == null || attributes.isEmpty()) {
	        return null;
		}
		return (String)attributes.get("mail");
    }

    /**
     * Point d'entre du CRON
     * @param args La liste des arguments
     */
    public static void main(String[] args) {
        new CRONNotification().start();
    }
}
