package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.Grant;
import org.esupportail.portal.channels.CIntranet.beans.Group;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.utils.Groups;
import org.esupportail.portal.utils.Users;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.RDBMServices;

/**
 * GrantAccess<br>
 * <br>
 * Ralise les oprations relatives aux droits dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class GrantAccess {
    
    protected static Log log = LogFactory.getLog(GrantAccess.class);
    
    /**
     * Retourne la liste des droits d'un dossier
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @return grants La liste des droits
     * @throws DataException
     */
    public static List getGrants(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("GrantAccess::getGrants()");
        }
        List res = new ArrayList();
        String sql = "SELECT * FROM INT_GRANT WHERE ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            while(rs.next()) {
                Grant tmp = new Grant();
                tmp.setFolderid(rs.getString("ID_FOL"));
                tmp.setLevel(rs.getInt("TYPE_GRT"));
                if(rs.getString("TYPE_ENT").equals("U")) {
                    User user = new User();
                    user.setId(rs.getString("ID_ENT"));
                    tmp.setGranted(user);
                }
                else {
                    Group group = new Group();
                    group.setId(rs.getString("ID_ENT"));
                    tmp.setGranted(group);
                }
                if(rs.getString("EXT_GRT").equals("1")) {
                    tmp.setExtended(true);
                }
                else {
                    tmp.setExtended(false);
                }
                if(rs.getString("NOT_GRT").equals("1")) {
                    tmp.setNotification(true);
                }
                else {
                    tmp.setNotification(false);
                }
                res.add(tmp);
            }
        }
        catch(SQLException e) {
            log.error("GrantAccess::getGrants() : " + e);
			log.error("GrantAccess::getGrants() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des droits");
        }
        return res;
    }
    
    /**
     * Ajoute un droit
     * @param query La connexion  utiliser
     * @param grant Le droit  ajouter
     * @throws DataException
     */
    public static void addGrant(Query query, Grant grant) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("GrantAccess::addGrant()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO INT_GRANT(ID_FOL, TYPE_GRT, ID_ENT, EXT_GRT, NOT_GRT, TYPE_ENT) VALUES(");
        sql.append(grant.getFolderid() + ", ");
        sql.append(grant.getLevel() + ", ");
        sql.append("'" + grant.getGranted().getId() + "', ");
        if(grant.isExtended()) {
            sql.append("'1', ");
        }
        else {
            sql.append("'0', ");
        }
        if(grant.isNotification()) {
            sql.append("'1', ");
        }
        else {
            sql.append("'0', ");
        }
        if(grant.getGranted() instanceof User) {
            sql.append("'U')");
        }
        else {
            sql.append("'G')");
        }
        try {
            query.setSql(sql.toString());
            query.insert();
        }
        catch(SQLException e) {
            log.error("GrantAccess::addGrant() : " + e);
			log.error("GrantAccess::addGrant() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout du droit");
        }
    }
    
    /**
     * Supprime un droit
     * @param query La connexion  utiliser
     * @param grant Le droit  supprimer
     * @throws DataException
     */
    public static void removeGrant(Query query, Grant grant) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("GrantAccess::removeGrant()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM INT_GRANT WHERE ");
        sql.append("ID_FOL = " + grant.getFolderid() + " AND ");
        sql.append("TYPE_GRT = " + grant.getLevel() + " AND ");
        sql.append("ID_ENT = '" + grant.getGranted().getId() + "' AND ");
        if(grant.getGranted() instanceof User) {
            sql.append("TYPE_ENT = 'U'");
        }
        else {
            sql.append("TYPE_ENT = 'G'");
        }
        try {
            query.setSql(sql.toString());
            query.delete();
        }
        catch(SQLException e) {
            log.error("GrantAccess::removeGrant() : " + e);
			log.error("GrantAccess::removeGrant() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du droit");
        }
    }
    
    /**
     * Supprime tous les drois d'un dossier
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @throws DataException
     */
    public static void removeGrants(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("GrantAccess::removeGrants()");
        }
        String sql = "DELETE FROM INT_GRANT WHERE ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.delete();
        }
        catch(SQLException e) {
            log.error("GrantAccess::removeGrants() : " + e);
			log.error("GrantAccess::removeGrants() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression des droits");
        }
    }
    
    /**
     * Modifie un droit
     * @param query La connexion  utiliser
     * @param grant Le droit  modifier
     * @throws DataException
     */
    public static void updateGrant(Query query, Grant grant) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("GrantAccess::updateGrant()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE INT_GRANT SET ");
        if(grant.isNotification()) {
            sql.append("NOT_GRT = '1'");
        }
        else {
            sql.append("NOT_GRT = '0'");
        }
        sql.append(" WHERE ID_FOL = " + grant.getFolderid() + " AND ");
        sql.append("TYPE_GRT = " + grant.getLevel() + " AND ");
        sql.append("TYPE_ENT = 'U' AND ");
        sql.append("ID_ENT = '" + grant.getGranted().getId() + "'");
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.error("GrantAccess::updateGrant() : " + e);
			log.error("GrantAccess::updateGrant() : SQL : " + sql);
			throw new DataException("Erreur lors de la modification du droit");
        }
    }

    /**
     * Teste si un droit existe dj
     * @param query La connexion  utiliser
     * @param grant Le droit  tester
     * @return boolean True si le droit existe, false sinon
     * @throws DataException
     */
    public static boolean grantExist(Query query, Grant grant) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("GrantAccess::grantExist()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM INT_GRANT WHERE ID_FOL = " + grant.getFolderid() + " AND ");
        sql.append("ID_ENT = '" + grant.getGranted().getId() + "' AND ");
        sql.append("TYPE_GRT >= " + grant.getLevel() + " AND ");
        if(grant.getGranted() instanceof User) {
            sql.append("TYPE_ENT = 'U'");
        }
        else {
            sql.append("TYPE_ENT = 'G'");
        }
        try {
            query.setSql(sql.toString());
            query.select();
            ResultSet rs = query.getRs();
            return rs.next();
        }
        catch(SQLException e) {
            log.error("GrantAccess::grantExist() : " + e);
		    log.error("GrantAccess::grantExist() : SQL : " + sql);
			throw new DataException("Erreur lors de la v\u00E9rification d'existence");
        }
    }
}
