package org.esupportail.portal.channels.CIntranet.data;

import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.database.Query;

/**
 * OrderAccess<br>
 * <br>
 * Ralise les oprations relatives  l'ordre des documents dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class OrderAccess {
    
    protected static final Log log = LogFactory.getLog(OrderAccess.class);
    
    /**
     * Monte la pile de priorit de 1 rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @throws DataException
     */
    public static void pushDocument(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::pushDocument()");
        }
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = ORDER_DOC + 1 WHERE ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::pushDocument() : " + e);
			log.error("OrderAccess::pushDocument() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
    
    /**
     * Descend la pile de priorit  partir d'un certain rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param order Le rang  partir duquel on travaille
     * @throws DataException
     */
    public static void pullDocument(Query query, String id, String order) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::pullDocument()");
        }
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = ORDER_DOC - 1 WHERE ID_FOL = " + id + " AND ORDER_DOC > " + order;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::pullDocument() : " + e);
			log.error("OrderAccess::pullDocument() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
    
    /**
     * Echange le rang de deux documents
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param doc L'identifiant du document
     * @param oldorder L'ancien rang du document
     * @param neworder Le nouveau rang du document
     * @throws DataException
     */
    public static void swapDocument(Query query, String id, String doc, String oldorder, String neworder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::swapDocument()");
        }
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = " + oldorder + " WHERE ORDER_DOC = " + neworder + " AND ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.update();
            sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = " + neworder + " WHERE ID_DOC = '" + doc + "' AND ID_FOL = " + id;
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::swapDocument() : " + e);
			log.error("OrderAccess::swapDocument() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
}