package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Entity;
import org.esupportail.portal.channels.CIntranet.beans.Group;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.utils.database.Query;

/**
 * PopulationAccess<br>
 * <br>
 * Ralise les oprations relatives aux population dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class PopulationAccess {
    
    protected static Log log = LogFactory.getLog(PopulationAccess.class);
    
    /**
     * Retourne la liste des entits d'un intranet 
     * @param query la connexion  utiliser
     * @param id l'identifiant de l'intranet
     * @return entities La liste des entits
     * @throws DataException
     */
    public static List getIntranetEntities(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("PopulationAccess::getIntranetEntities()");
        }
        List entities = new ArrayList();
        String sql = "SELECT * FROM INT_ENTITIES WHERE ID_INT = '" + id + "'";
        try  {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            while(rs.next()) {
                Entity tmp = null;
                if(rs.getString("TYPE_ENT").equals("U")) {
                    tmp = new User();
                }
                else {
                    tmp = new Group();
                }
                tmp.setId(rs.getString("ID_ENT"));
                entities.add(tmp);
            }
        }
        catch(SQLException e) {
            log.error("PopulationAccess::getIntranetEntities() : " + e);
		    log.error("PopulationAccess::getIntranetEntities() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des entit\u00E9s");
        }
        return entities;
    }
    
    /**
     * Ajoute une entit  la population d'un intranet
     * @param query la connexion  utiliser
     * @param en l'entit  ajouter
     * @param id l'identifiant de l'intranet
     * @throws DataException
     */
    public static void addIntranetEntity(Query query, Entity en, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("PopulationAccess::addIntranetEntity()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO INT_ENTITIES(ID_INT, ID_ENT, TYPE_ENT) VALUES(");
        sql.append("'" + id + "', ");
        sql.append("'" + en.getId() + "', ");
        if(en instanceof User) {
            sql.append("'U')");
        }
        else {
            sql.append("'G')");
        }
        try {
            query.setSql(sql.toString());
            query.insert();
        }
        catch(SQLException e) {
            log.error("PopulationAccess::addIntranetEntity() : " + e);
		    log.error("PopulationAccess::addIntranetEntity() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout de l' entit\u00E9");
        }
    }
    
    /**
     * Supprime une entit de la population d'un intranet
     * @param query la connexion  utiliser
     * @param en l'entit  supprimer
     * @param id l'identifiant de l'intranet
     * @throws DataException
     */
    public static void removeIntranetEntity(Query query, Entity en, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("PopulationAccess::removeIntranetEntity()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM INT_ENTITIES WHERE ID_INT = '" + id + "' AND ");
        sql.append("ID_ENT = '" + en.getId() + "' AND ");
        if(en instanceof User) {
            sql.append("TYPE_ENT = 'U'");
        }
        else {
            sql.append("TYPE_ENT = 'G'");
        }
        try {
            query.setSql(sql.toString());
            query.delete();
        }
        catch(SQLException e) {
            log.error("PopulationAccess::removeIntranetEntity() : " + e);
		    log.error("PopulationAccess::removeIntranetEntity() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression de l' entit\u00E9");
        }
    }
    
    /**
     * Supprime toutes les entits de la population d'un intranet
     * @param query la connexion  utiliser
     * @param id l'identifiant de l'intranet
     * @throws DataException
     */
    public static void removeAllIntranetEntities(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("PopulationAccess::removeAllIntranetEntities()");
        }
        String sql = "DELETE FROM INT_ENTITIES WHERE ID_INT = '" + id + "'";
        try {
            query.setSql(sql);
            query.delete();
        }
        catch(SQLException e) {
            log.error("PopulationAccess::removeAllIntranetEntities() : " + e);
		    log.error("PopulationAccess::removeAllIntranetEntities() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression des entit\u00E9s");
        }
    }
}
