package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.DocumentFile;
import org.esupportail.portal.channels.CIntranet.beans.DocumentLink;
import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.esupportail.portal.utils.database.Query;

/**
 * SearchAccess<br>
 * <br>
 * Ralise les oprations relatives aux recherches dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class SearchAccess {
    
    protected static Log log = LogFactory.getLog(SearchAccess.class);
    
    /**
     * Retourne la liste des documents en attente de validation
     * @param query La connexion  utiliser
     * @param intranet L'identifiant de l'intranet
     * @return docs La liste des documents
     * @throws DataException
     */
    public static List getInvalidDocuments(Query query, String intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchAccess::getInvalidDocuments()");
        }
        List docs = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM INT_DOCUMENT WHERE ID_INT = '" + intranet + "' AND (");
        sql.append("VALID_DOC = '0' OR PENDD_DOC = '1' OR PENDM_DOC = '1'");
        sql.append(")");
        try {
            query.setSql(sql.toString());
            query.select();
            ResultSet result = query.getRs();
            while(result.next()) {
                docs.add(getDocument(result));
            }
        }
        catch(SQLException e) {
            log.error("SearchAccess::getInvalidDocuments() : " + e);
			log.error("SearchAccess::getInvalidDocuments() : SQL : " + sql);
			throw new DataException("Erreur lors de la recherche des documents invalides");
        }
        return docs;
    }
    
    /**
     * Retourne la liste des documents prims
     * @param query La connexion  utiliser
     * @param intranet L'identifiant de l'intranet
     * @return docs La liste des documents
     * @throws DataException
     */
    public static List getPerimedDocuments(Query query, String intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchAccess::getPerimedDocuments()");
        }
        List docs = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM INT_DOCUMENT WHERE ID_INT = '" + intranet + "' AND ");
        sql.append("DATEVAL_DOC < '" + Date.getCurrentDate() + "' AND VALID_DOC = '1' AND ");
        sql.append("PENDM_DOC = '0' AND PENDD_DOC = '0'");
        try {
            query.setSql(sql.toString());
            query.select();
            ResultSet result = query.getRs();
            while(result.next()) {
                docs.add(getDocument(result));
            }
        }
        catch(SQLException e) {
            log.error("SearchAccess::getPerimedDocuments() : " + e);
			log.error("SearchAccess::getPerimedDocuments() : SQL : " + sql);
			throw new DataException("Erreur lors de la recherche des documents p\u00E9rim\u00E9s");
        }
        return docs;
    }
    
    /**
     * Retourne les n derniers documents d'un intranet
     * @param query La connexion  utiliser
     * @param intranet L'identifiant de l'intranet
     * @param count Le nombre de documents  retourner
     * @return docs La liste des documents
     * @throws DataException
     */
    public static List getLastDocuments(Query query, String intranet, int count) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchAccess::getLastDocuments()");
        }
        List docs = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM INT_DOCUMENT WHERE ID_INT = '" + intranet + "' AND VALID_DOC = '1' AND ");
        sql.append("PENDD_DOC = '0' AND PENDM_DOC = '0' ORDER BY DATE_DOC DESC");
        try {
            query.setSql(sql.toString());
            query.select();
            ResultSet result = query.getRs();
            while(result.next() && count-- > 0) {
                docs.add(getDocument(result));
            }
        }
        catch(SQLException e) {
            log.error("SearchAccess::getLastDocuments() : " + e);
			log.error("SearchAccess::getLastDocuments() : SQL : " + sql);
			throw new DataException("Erreur lors de la recherche des documents");
        }
        return docs;
    }

    /**
     * Retourne les documents correspondants aux critres de recherche
     * @param query La connexion  utiliser
     * @param intranet L'identifiant de l'intranet
     * @param type Le type de document (F, L ou %)
     * @param name Le template de nom (%template% ou %)
     * @param description Le template de description (%template% ou %)
     * @return docs La liste des documents
     * @throws DataException
     */
    public static List getCustomDocuments(Query query, String intranet, String type, String name, String description) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchAccess::getCustomDocuments()");
        }
        List docs = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM INT_DOCUMENT WHERE ID_INT = '" + intranet + "' AND ");
        sql.append("TYPE_DOC LIKE '" + type + "' AND ");
        sql.append("NAME_DOC LIKE '" + name + "' AND ");
        sql.append("DES_DOC LIKE '" + description + "' AND VALID_DOC = '1' AND ");
        sql.append("PENDM_DOC = '0' AND PENDD_DOC = '0'");
        try {
            query.setSql(sql.toString());
            query.select();
            ResultSet result = query.getRs();
            while(result.next()) {
                Document doc = null;
                if(result.getString("TYPE_DOC").equals("F")) {
                    DocumentFile df = new DocumentFile();
                    df.setFile(result.getString("FILE_DOC"));
                    df.setExtension(result.getString("EXT_DOC"));
                    doc = df;
                }
                else {
                    DocumentLink dl = new DocumentLink();
                    dl.setUrl(result.getString("URL_DOC"));
                    doc = dl;
                }
                doc.setId(result.getString("ID_DOC"));
                doc.setFolderid(result.getString("ID_FOL"));
                doc.setName(result.getString("NAME_DOC"));
                doc.setDescription(result.getString("DES_DOC"));
                doc.setAuthor(result.getString("AUT_DOC"));
                doc.setDate(result.getString("DATE_DOC"));
                doc.setValidityDate(result.getString("DATEVAL_DOC"));
                if(result.getString("VALID_DOC").equals("1")) {
                    doc.setValid(true);
                }
                else {
                    doc.setValid(false);
                }
                if(result.getString("PENDM_DOC").equals("1")) {
                    doc.setPendingModification(true);
                }
                else {
                    doc.setPendingModification(false);
                }
                if(result.getString("PENDD_DOC").equals("1")) {
                    doc.setPendingDeletion(true);
                }
                else {
                    doc.setPendingDeletion(false);
                }
                if(result.getString("HIDDEN_DOC").equals("1")) {
                    doc.setVisible(false);
                }
                else {
                    doc.setVisible(true);
                }
                docs.add(doc);
            }
        }
        catch(SQLException e) {
            log.error("SearchAccess::getCustomDocuments() : " + e);
			log.error("SearchAccess::getCustomDocuments() : SQL : " + sql);
			throw new DataException("Erreur lors de la recherche des documents");
        }
        return docs;
    }

    /**
     * Rcupre un document dans un ResultSet SQL
     * @param result Le ResultSet
     * @return doc Le document
     * @throws SQLException
     */
    private static Document getDocument(ResultSet result) throws SQLException {
        Document doc = null;
        if(result.getString("TYPE_DOC").equals("F")) {
            DocumentFile df = new DocumentFile();
            df.setFile(result.getString("FILE_DOC"));
            df.setExtension(result.getString("EXT_DOC"));
            doc = df;
        }
        else {
            DocumentLink dl = new DocumentLink();
            dl.setUrl(result.getString("URL_DOC"));
            doc = dl;
        }
        doc.setIntranet(result.getString("ID_INT"));
        doc.setId(result.getString("ID_DOC"));
        doc.setFolderid(result.getString("ID_FOL"));
        doc.setName(result.getString("NAME_DOC"));
        doc.setDescription(result.getString("DES_DOC"));
        doc.setAuthor(result.getString("AUT_DOC"));
        doc.setDate(result.getString("DATE_DOC"));
        doc.setValidityDate(result.getString("DATEVAL_DOC"));
        if(result.getString("VALID_DOC").equals("1")) {
            doc.setValid(true);
        }
        else {
            doc.setValid(false);
        }
        if(result.getString("PENDM_DOC").equals("1")) {
            doc.setPendingModification(true);
        }
        else {
            doc.setPendingModification(false);
        }
        if(result.getString("PENDD_DOC").equals("1")) {
            doc.setPendingDeletion(true);
        }
        else {
            doc.setPendingDeletion(false);
        }
        if(result.getString("HIDDEN_DOC").equals("1")) {
            doc.setVisible(false);
        }
        else {
            doc.setVisible(true);
        }
        return doc;
    }
}
