<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}functions.js">
</script>

	<table width="100%" border="0" cellspacing="0" cellpadding="5">
		<tr>		
			<!-- Affichage Nouvel Intranet -->
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=newintranet">
					<img src="{$mediaPath}26x26ab/newfile.gif" border="0" alt="Nouvel Intranet" title="Nouvel Intranet" />
				</a>
			</td>
			<td class="uportal-label" nowrap="true">
				<a href="{$baseActionURL}?action=newintranet">Nouvel Intranet</a>
			</td>
			
			<!-- Affichage Types MIME -->
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=mimes">
					<img src="{$mediaPath}26x26ab/mimes.gif" border="0" alt="Extensions" title="Extensions" />
				</a>
			</td>
			<td class="uportal-label" nowrap="true">
				<a href="{$baseActionURL}?action=mimes">Extensions</a>
			</td>
			
			<!-- Affichage Administrateurs -->
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=admins">
					<img  src="{$mediaPath}26x26ab/admin.gif" border="0" alt="Administrateurs" title="Administrateurs" />
				</a>
			</td>
			<td class="uportal-label" nowrap="true">
				<a href="{$baseActionURL}?action=admins">Administrateurs</a>
			</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	
	<!-- Affichage des intranets -->
	<xsl:apply-templates select="intranets" />

</xsl:template>
	
<!-- Affichage des intranets -->
<xsl:template match="intranets">
	
	<xsl:choose>
		<xsl:when test="count(intranet)=0">
			<table border="0" width="100%" cellpadding="1" cellspacing="0">
				<tr>
					<td class="uportal-channel-error">Aucun intranet</td>
				</tr>
			</table>
		</xsl:when>
		<xsl:otherwise>
			<br/>
			<table border="0" width="100%" cellpadding="1" cellspacing="0">
			<!-- Affichage des intranets -->
			<xsl:apply-templates select="intranet" />
		</table>
		</xsl:otherwise>		
	</xsl:choose>
	
</xsl:template>

<!-- Affichage d'un intranet -->
<xsl:template match="intranet">
	
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
	
		<!-- Icône suppression -->
		<td align="center" valign="absmiddle">
			<a href="{$baseActionURL}?action=removeintranet&amp;id={./@id}">
				<img  src="{$mediaPath}20x20sb/del.gif" border="0" alt="Supprimer" title="Supprimer" />
			</a>
		</td>
	
		<!-- Icône population -->
		<td align="center" valign="absmiddle">
			<a href="{$baseActionURL}?action=population&amp;id={./@id}">
				<img  src="{$mediaPath}20x20sb/permissions.gif" border="0" alt="Population" title="Population" />
			</a>
		</td>
	
		<td width="5%">&#160;</td>
	
		<!-- Affichage Intranet -->
		<td class="uportal-label" nowrap="true">
			<xsl:value-of select="./@name" />
		</td>
	
		<td width="5%">&#160;</td>
	
		<!-- Affichage Ressource -->
		<td class="uportal-text-small" nowrap="true">
			<xsl:value-of select="./@ressource" />
		</td>
	
		<td width="100%">&#160;</td>
	</tr>
	
</xsl:template>

</xsl:stylesheet>