<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>

<table border="0" width="100%" cellspacing="0" cellpadding="5">
	<tr>
		<td class="uportal-channel-table-header" nowrap="true">Population</td>
		<td>
			<a href="{$baseActionURL}?action=admin">
				<img  src="{$mediaPath}26x26ab/back.gif" alt="Retour" title="Retour" border="0" />
			</a>
		</td>
		<td width="100%">&#160;</td>
	</tr>
</table>
<hr/>
<br/>

<xsl:apply-templates select="entities" />

</xsl:template>

<xsl:template match="entities">
<table border="0" width="100%" cellpadding="1" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption" width="50%">Groupes</td>
		<td class="uportal-channel-table-caption" width="50%">Utilisateurs</td>
	</tr>
	<tr valign="top">
		<td>
			<table border="0" width="100%" cellpadding="1" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-caption" nowrap="true">Nom</td>
					<td class="uportal-channel-table-caption" nowrap="true">Supprimer</td>
					<td width="100%">&#160;</td>
				</tr>
					<xsl:apply-templates select="group" />						
			</table>
			<br/>
			<form method="post" action="{$baseActionURL}">
				<input type="hidden" name="action" value="groupsmanager" />
				<input class="uportal-button" type="submit" value="Ajouter" name="butadd" />
			</form>
		</td>
		
		<td>
			<table border="0" width="100%" cellpadding="1" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-caption" nowrap="true">Nom</td>
					<td class="uportal-channel-table-caption" nowrap="true">Supprimer</td>
					<td width="100%">&#160;</td>
				</tr>
				<xsl:apply-templates select="user" />
			</table>
			<br/>
			<form method="post" action="{$baseActionURL}">
				<input type="hidden" name="action" value="annuaire" />
				<input class="uportal-button" type="submit" value="Ajouter" name="butadd" />
			</form>
		</td>
	</tr>
</table>

</xsl:template>

<xsl:template match="group">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<td><img  src="{$mediaPath}20x20sb/group.gif" border="0" /></td>
		<td class="uportal-channel-text" nowrap="true"><xsl:value-of select="./@name" /></td>
		<td align="center" valign="absmiddle">
			<a href="{$baseActionURL}?action=delgroup&amp;id={./@id}">
				<img src="{$mediaPath}20x20sb/del.gif" alt="Supprimer" title="Supprimer" border="0" />
			</a>
		</td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template match="user">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<td><img  src="{$mediaPath}20x20sb/user.gif" border="0" /></td>
		<td class="uportal-channel-text" nowrap="true"><xsl:value-of select="./@name" /></td>
		<td align="center" valign="absmiddle">
			<a href="{$baseActionURL}?action=deluser&amp;id={./@id}">
				<img  src="{$mediaPath}20x20sb/del.gif" alt="Supprimer" title="Supprimer" border="0" />
			</a>
		</td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

</xsl:stylesheet>