<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="folder" />

<xsl:template match="xml">
	
	<table border="0" width="100%" cellspacing="0" cellpadding="5">
		<tr>
			<td class="uportal-channel-table-header" nowrap="true">Modification lien</td>
			<td>
				<a href="{$baseActionURL}?action=viewfolder&amp;folder={$folder}">
					<img src="{$mediaPath}26x26ab/back.gif" alt="Retour" title="Retour" border="0" />
				</a>
			</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	
	<xsl:apply-templates select="document" />
	
</xsl:template>

<xsl:template match="document">
	
	<table border="0" cellpadding="2" cellspacing="1">
		<tr class="uportal-background-highlight">
			<td class="uportal-label" nowrap="true">Modifier les informations :</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
		
	<form method="post" action="{$baseActionURL}">
	<input type="hidden" name="action" value="modlink" />
	<input type="hidden" name="folder" value="{$folder}" />
	<table border="0">
		<tr>
			<td class="uportal-text">Nom :</td>
			<td class="uportal-text"><input type="text" size="40" class="uportal-input-text" name="name" value="{./@name}" /></td>
		</tr>
		<tr>
			<td class="uportal-text">Description :</td>
			<td class="uportal-text"><input type="text" size="40" class="uportal-input-text" name="description" value="{./@description}" /></td>
		</tr>
		<tr>
			<td class="uportal-text">Lien :</td>
			<td class="uportal-text"><input type="text" size="40" class="uportal-input-text" name="link" value="{./@url}" /></td>
		</tr>
	</table>
	<br/>
	<input type="submit" class="uportal-button" value="Valider" />
	</form>
	
	<br/>
	
	<table border="0" cellpadding="2" cellspacing="1">
		<tr class="uportal-background-highlight">
			<td class="uportal-label" nowrap="true">Modifier la date de premption :</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	
	<form method="post" action="{$baseActionURL}">
	<input type="hidden" name="action" value="modvaliditydate" />
	<input type="hidden" name="folder" value="{$folder}" />
	<table border="0">
		<tr>
			<td class="uportal-text">Date de premption :</td>
			<td class="uportal-text"><input type="text" class="uportal-input-text" name="date" value="{./@validityinput}" maxlength="10" /></td>
		</tr>
	</table>
	<br/>
	<input type="submit" class="uportal-button" value="Valider" />
	</form>
			
</xsl:template>

</xsl:stylesheet>