<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	
<xsl:import href="./Search_templates.xsl" />

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="baseDownloadURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="folder" />

<xsl:template match="xml">

	<script language="javascript" src="{$mediaPath}functions.js" >
	</script>
	
	<table border="0" width="100%" cellspacing="0" cellpadding="5">
		<tr>
			<td class="uportal-channel-table-header" nowrap="true">Rsultats - Documents correspondant aux critres</td>
			<td>
				<a href="{$baseActionURL}?action=search&amp;new=1">
					<img src="{$mediaPath}26x26ab/find.gif" alt="Nouvelle recherche" title="Nouvelle recherche" border="0" />
				</a>
			</td>
			<td>
				<a href="{$baseActionURL}?action=viewfolder&amp;folder={$folder}">
					<img src="{$mediaPath}26x26ab/back.gif" alt="Retour" title="Retour" border="0" />
				</a>
			</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	
	<xsl:apply-templates select="results" />
		
</xsl:template>

<xsl:template match="results">
	
	<table border="0" width="100%" cellspacing="0" cellpadding="2">
	
	<xsl:choose>
		<xsl:when test="count(result)=0">
			<tr>
				<td class="uportal-channel-error">Aucun rsultat pour votre recherche</td>
			</tr>
		</xsl:when>
		<xsl:otherwise>
			<tr class="uportal-background-med">
				<td class="uportal-label">Chemin</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td class="uportal-label">Nom</td>
				<td>&#160;</td>
				<td class="uportal-label">Description</td>
				<td>&#160;</td>
				<td class="uportal-label">Auteur</td>
				<td>&#160;</td>
				<td class="uportal-label">Date</td>
				<td width="100%">&#160;</td>
			</tr>
			<xsl:apply-templates select="result" />
		</xsl:otherwise>
	</xsl:choose>
	
	</table>
	
</xsl:template>

<xsl:template match="result">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<xsl:apply-templates select="path" />
		<td>&#160;</td>
		<xsl:apply-templates select="document" />
	</tr>
</xsl:template>


<xsl:template match="document">
	<td valign="absmiddle">
		<a href="{$baseActionURL}?action=viewdocument&amp;folder={./@folder}&amp;id={./@id}">
			<img src="{$mediaPath}20x20sb/find.gif" border="0" alt="Dtails" title="Dtails" />
		</a>
	</td>
	<xsl:call-template name="document.icon" />
	<xsl:call-template name="document.name" />
	<td>&#160;</td>
	<td class="uportal-text" nowrap="true"><xsl:value-of select="./@description" /></td>
	<td>&#160;</td>
	<td class="uportal-text" nowrap="true"><xsl:value-of select="./@author" /></td>
	<td>&#160;</td>
	<td class="uportal-text" nowrap="true"><xsl:value-of select="./@datetext" /></td>
	<td width="100%">&#160;</td>	
</xsl:template>
</xsl:stylesheet>