<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="baseDownloadURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="folder" />

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>

	<table border="0" width="100%" cellspacing="0" cellpadding="5">
		<tr>
			<td class="uportal-channel-table-header" nowrap="true">Dtails d'un document</td>
			<td>
				<a href="{$baseActionURL}?action=viewfolder&amp;folder={$folder}">
					<img src="{$mediaPath}26x26ab/back.gif" alt="Retour" title="Retour" border="0" />
				</a>
			</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	
	<xsl:call-template name="validation" />
	<xsl:apply-templates select="document" />

</xsl:template>

<xsl:template name="validation">
	
	<table border="0" cellpadding="2" cellspacing="0">
		<tr>
			<td class="uportal-label" nowrap="true">Souhaitez-vous valider le dpt de ce document ?</td>
			<td>&#160;</td>
			<td class="uportal-label">
				<a href="{$baseActionURL}?action=valid&amp;folder={$folder}&amp;id={./document/@id}">Oui</a>
			</td>
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=valid&amp;folder={$folder}&amp;id={./document/@id}">
					<img src="{$mediaPath}20x20sb/invalid.gif" border="0" />
				</a>
			</td>
			<td>&#160;</td>
			<td class="uportal-label">
				<a href="{$baseActionURL}?action=dismiss&amp;folder={$folder}&amp;id={./document/@id}">Non</a>
			</td>
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=dismiss&amp;folder={$folder}&amp;id={./document/@id}">
					<img src="{$mediaPath}20x20sb/validnot.gif" border="0" />
				</a>
			</td>
		</tr>
	</table>
	<br/>
	
</xsl:template>


<xsl:template match="document">
	
	<xsl:choose>
		
		<xsl:when test="./@type='file'">
			<xsl:call-template name="document.file" />
		</xsl:when>
		
		<xsl:when test="./@type='link'">
			<xsl:call-template name="document.link" />
		</xsl:when>
		
	</xsl:choose>
	
</xsl:template>


<xsl:template name="document.file">
	
	<table border="0" cellpadding="2" cellspacing="0">
		<tr>
			<td class="uportal-label" nowrap="true">Nom : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true">
				<a href="{$baseDownloadURL}?action=download&amp;folder={$folder}&amp;id={./@id}">
					<xsl:value-of select="./@file" />
				</a>
			</td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Description : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@description" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Auteur : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@author" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Date : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		</tr>
	</table>
	
</xsl:template>

<xsl:template name="document.link">
	
	<table border="0" cellpadding="2" cellspacing="0">
		<tr>
			<td class="uportal-label" nowrap="true">URL : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true">
				<a href="{./@url}" target="_blank">
					<xsl:value-of select="./@url" />
				</a>
			</td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Description : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@description" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Auteur : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@author" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Date : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		</tr>
	</table>
	
</xsl:template>


</xsl:stylesheet>