<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<!--#####################################################-->
<!--                                                     -->                       
<!--                    Barre d'outils                   -->
<!--                                                     -->
<!--#####################################################-->


<!-- Bouton nouveau document -->
<xsl:template name="outil.nouveau.document">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=newdocument&amp;folder={./folder/@id}">
		<img src="{$mediaPath}26x26ab/newfile.gif" border="0" alt="Nouveau Document" title="Nouveau Document" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=newdocument&amp;folder={./folder/@id}">Nouveau document</a>
</td>
	
</xsl:template>

<!-- Bouton nouveau dossier -->
<xsl:template name="outil.nouveau.dossier">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=newfolder&amp;folder={./folder/@id}">
		<img src="{$mediaPath}26x26ab/newfolder.gif" border="0" alt="Nouveau Dossier" title="Nouveau Dossier" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=newfolder&amp;folder={./folder/@id}">Nouveau dossier</a>
</td>

</xsl:template>

<!-- Bouton recherche -->
<xsl:template name="outil.recherche">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=search&amp;folder={./folder/@id}">
		<img src="{$mediaPath}26x26ab/find.gif" border="0" alt="Recherche" title="Recherche" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=search">Recherche</a>
</td>

</xsl:template>

<!-- Bouton permissions -->
<xsl:template name="outil.permissions">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=permissions&amp;folder={./folder/@id}">
		<img src="{$mediaPath}26x26ab/permissions.gif" border="0" alt="Permissions" title="Permissions" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=permissions&amp;folder={./folder/@id}">Permissions</a>
</td>

</xsl:template>

<!-- Bouton arbre -->
<xsl:template name="outil.arbre">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=viewtree&amp;folder={./folder/@id}">
		<img src="{$mediaPath}26x26ab/tree.gif" border="0" alt="Plan" title="Plan" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=viewtree&amp;folder={./folder/@id}">Plan</a>
</td>

</xsl:template>

<!-- Bouton intranets -->
<xsl:template name="outil.intranets">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=intranet">
		<img src="{$mediaPath}26x26ab/home.gif" border="0" alt="Intranets" title="Intranets" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=intranet">Intranets</a>
</td>

</xsl:template>

<!--#####################################################-->
<!--                                                     -->                       
<!--                        Chemin                       -->
<!--                                                     -->
<!--#####################################################-->


<xsl:template match="path/folder">
	<td class="uportal-channel-table-header" nowrap="true">
		<a href="{$baseActionURL}?action=viewfolder&amp;folder={./@id}"><xsl:value-of select="./@name" /></a>&#160;&#62;
	</td>	
</xsl:template>

<!--#####################################################-->
<!--                                                     -->                       
<!--                       Dossiers                      -->
<!--                                                     -->
<!--#####################################################-->


<xsl:template name="dossier.modification">
	<tr>
		<td valign="absmiddle">
			<a href="{$baseActionURL}?action=modfolder&amp;folder={/xml/folder/@id}&amp;id={./@id}">
				<img src="{$mediaPath}20x20sb/modify.gif" border="0" alt="Modifier" title="Modifier" />
			</a>
		</td>
		<td valign="absmiddle">
			<a href="{$baseActionURL}?action=delfolder&amp;folder={/xml/folder/@id}&amp;id={./@id}">
				<img src="{$mediaPath}20x20sb/del.gif" border="0" alt="Supprimer" title="Supprimer" />
			</a>
		</td>
		<td width="5">&#160;</td>
		<td valign="absmiddle">
			<a href="{$baseActionURL}?action=viewfolder&amp;folder={./@id}">
				<img src="{$mediaPath}20x20sb/folder.gif" border="0" />
			</a>
		</td>
		<td class="uportal-label" nowrap="true">
			<a href="{$baseActionURL}?action=viewfolder&amp;folder={./@id}"><xsl:value-of select="./@name" /></a>
		</td>
		<td width="5">&#160;</td>
		<xsl:choose>
			<xsl:when test="./@datetext != ''">
				<td class="uportal-text-small" nowrap="true">Dernire modification <xsl:value-of select="./@datetext" /></td>
			</xsl:when>
			<xsl:otherwise>
				<td>&#160;</td>
			</xsl:otherwise>
		</xsl:choose>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template name="dossier.visualisation">
	<tr align="left">
		<td valign="absmiddle">
			<a href="{$baseActionURL}?action=viewfolder&amp;folder={./@id}">
				<img src="{$mediaPath}20x20sb/folder.gif" border="0" />
			</a>
		</td>
		<td class="uportal-label" nowrap="true">
			<a href="{$baseActionURL}?action=viewfolder&amp;folder={./@id}"><xsl:value-of select="./@name" /></a>
		</td>
		<td width="5">&#160;</td>
		<xsl:choose>
			<xsl:when test="./@datetext != ''">
				<td class="uportal-text-small" nowrap="true">Dernire modification : <xsl:value-of select="./@datetext" /></td>
			</xsl:when>
			<xsl:otherwise>
				<td>&#160;</td>
			</xsl:otherwise>
		</xsl:choose>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<!--#####################################################-->
<!--                                                     -->                       
<!--                      Documents                      -->
<!--                                                     -->
<!--#####################################################-->

<xsl:template name="document.icon">
	<td align="absmiddle">
		<a href="{$baseDownloadURL}?action=download&amp;folder={./@folder}&amp;id={./@id}">
			<xsl:choose>
				<xsl:when test="./@extension='.doc'">
					<img src="{$mediaPath}docdoc.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.gz'">
					<img src="{$mediaPath}doczip.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.htm'">
					<img src="{$mediaPath}dochtm.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.html'">
					<img src="{$mediaPath}dochtm.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.pdf'">
					<img src="{$mediaPath}docpdf.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.ppt'">
					<img src="{$mediaPath}docppt.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.rar'">
					<img src="{$mediaPath}doczip.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.tar'">
					<img src="{$mediaPath}doczip.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.xls'">
					<img src="{$mediaPath}docxls.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.zip'">
					<img src="{$mediaPath}doczip.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:otherwise>
					<img src="{$mediaPath}docstd.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:otherwise>
			</xsl:choose>
		</a>
	</td>
</xsl:template>

<xsl:template name="document.outil.checkbox">
	<td><input type="checkbox" name="selected" value="{./@id}" /></td>
</xsl:template>

<xsl:template name="document.outil.zoom">
	<td>
		<a href="{$baseActionURL}?action=viewdocument&amp;folder={./@folder}&amp;id={./@id}">
			<img src="{$mediaPath}20x20sb/find.gif" border="0" alt="Dtails" title="Dtails" />
		</a>
	</td>
</xsl:template>

<xsl:template name="document.outil.modify">
	<td>
		<a href="{$baseActionURL}?action=moddocument&amp;folder={./@folder}&amp;id={./@id}">
			<img src="{$mediaPath}20x20sb/modify.gif" border="0" alt="Modifier" title="Modifier" />
		</a>
	</td>
</xsl:template>

<xsl:template name="document.outil.modify.off">
	<td>
		<img src="{$mediaPath}20x20sbg/modify.gif" border="0" alt="Modifier" title="Modifier" />
	</td>
</xsl:template>

<xsl:template name="document.outil.modify.alert">
	<td>
		<img src="{$mediaPath}20x20sba/modify.gif" border="0" alt="Modifier" title="Modifier" />
	</td>
</xsl:template>

<xsl:template name="document.outil.delete">
	<td>
		<a href="{$baseActionURL}?action=deldocument&amp;folder={./@folder}&amp;id={./@id}" onClick="return confirm('Voulez-vous rellement supprimer ce document ?');">
			<img src="{$mediaPath}20x20sb/delete.gif" border="0" alt="Supprimer" title="Supprimer" />
		</a>
	</td>
</xsl:template>

<xsl:template name="document.outil.delete.off">
	<td>
		<img src="{$mediaPath}20x20sbg/delete.gif" border="0" alt="Supprimer" title="Supprimer" />
	</td>
</xsl:template>

<xsl:template name="document.outil.delete.alert">
	<td>
		<img src="{$mediaPath}20x20sba/delete.gif" border="0" alt="Supprimer" title="Supprimer" />
	</td>
</xsl:template>

<xsl:template name="document.outil.visible">
	<td>
		<a href="{$baseActionURL}?action=hidedocument&amp;folder={./@folder}&amp;id={./@id}">
			<img src="{$mediaPath}20x20sb/visible.gif" border="0" alt="Cacher" title="Cacher" />
		</a>
	</td>
</xsl:template>

<xsl:template name="document.outil.visible.off">
	<td>
		<img src="{$mediaPath}20x20sbg/visible.gif" border="0" alt="Cacher" title="Cacher" />
	</td>
</xsl:template>

<xsl:template name="document.outil.visible.alert">
	<td>
		<a href="{$baseActionURL}?action=hidedocument&amp;folder={./@folder}&amp;id={./@id}">
			<img src="{$mediaPath}20x20sba/visible.gif" border="0" alt="Afficher" title="Afficher" />
		</a>
	</td>
</xsl:template>

<xsl:template name="document.outil.up.on">
	<td align="center" valign="middle">
		<a href="{$baseActionURL}?action=neworder&amp;id={./@id}&amp;folder={./@folder}&amp;rank={./@order}&amp;dir=up">
			<img  src="{$mediaPath}20x20sb/up.gif" border="0" alt="Monter" title="Monter" />			
		</a>
	</td>
</xsl:template>

<xsl:template name="document.outil.up.off">
	<td>&#160;</td>
</xsl:template>

<xsl:template name="document.outil.down.on">
	<td align="center" valign="middle">
		<a href="{$baseActionURL}?action=neworder&amp;id={./@id}&amp;folder={./@folder}&amp;rank={./@order}&amp;dir=down">
			<img  src="{$mediaPath}20x20sb/down.gif" border="0" alt="Descendre" title="Descendre" />			
		</a>
	</td>
</xsl:template>

<xsl:template name="document.outil.down.off">
	<td>&#160;</td>
</xsl:template>

</xsl:stylesheet>