package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.beans.XMLSerializable;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * NewIntranet<br>
 * <br>
 * Cette classe gre la cration d'un nouvel intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.3 $
 * 
 */
public class NewIntranet extends AbstractAction {
    
    protected static Log log = LogFactory.getLog(NewIntranet.class);
    
    private Collection ressources = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public NewIntranet(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de cration d'intranet
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("NewIntranet::init()");
        }
        ressources = Config.getInstance().getRessources().values();
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de cration d'intranet
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("NewIntranet::setXML()");
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<ressources>\n");
        for(Iterator i = ressources.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</ressources>\n");
        if(log.isDebugEnabled()) {
            log.debug("NewIntranet::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        return Boolean.TRUE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Ajoute le nouvel intranet
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean createinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("NewIntranet::createinit()");
        }
        String identifiant = getRuntimeData().getParameter("identifiant");
        String nom = getRuntimeData().getParameter("nom");
        String ressource = getRuntimeData().getParameter("ressource");
        
        if(identifiant == null || nom == null || ressource == null) {
            log.error("NewIntranet::createinit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");		
			return Boolean.FALSE;
        }
        
        if(identifiant.equals("") || nom.equals("") || ressource.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Tous les champs sont obligatoires"), "newintranet");
            return Boolean.FALSE;
        }
        
        if(Config.getInstance().getRessources().get(ressource) == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Ressource introuvable"), "newintranet");
            return Boolean.FALSE;
        }
        
        if(!identifiant.matches("[A-Z0-9_]{1,20}")) {
		    Message.message(getMainChannel(), getRuntimeData(), new MessageBean("L'identifiant ne doit comporter que des majuscules, des chiffres et le caract\u00E8re _"), "newintranet");
		    return Boolean.FALSE;
		}
        
        Intranet intranet = new Intranet();
        intranet.setId(identifiant);
        intranet.setName(nom);
        intranet.setRessource(ressource);
        
        DataControler data = new DataControler();
        IStorageControler storage = StorageFactory.make(ressource);
        
        try {
            data.createIntranet(intranet);
            storage.createIntranet(intranet);
            data.commit();
            data.close();
        }
        catch(DataException e) {
            log.error("NewIntranet::createinit() : DataException :\n" + e);
			Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
			return Boolean.FALSE;
        }
        catch(StorageException e) {
            log.error("NewIntranet::createinit() : StorageException :\n" + e);
			log.fatal("NewIntranet::createinit() : Possible incoh\u00E9rence du syst\u00E8me de fichiers !");
			data.rollback();
			data.close();
			Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
			return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "admin");
        return Boolean.FALSE;
    }
}
