package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.beans.XMLSerializable;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * Home<br>
 * <br>
 * Cette classe affiche la liste des intranets<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class Home extends SubChannel {

    protected static Log log = LogFactory.getLog(Home.class);
    
    private List intranets = null;
    
    private boolean admin = false;
    private boolean all = false;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public Home(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Construit la liste des intranets accessibles
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(log.isDebugEnabled()) {
            log.debug("Home::init()");
        }
        all = false;
        String login = mainChannel.getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
		String paramall = getRuntimeData().getParameter("all");
		if(paramall != null && paramall.equals("true")) {
		    all = true;
		}
		DataControler data = new DataControler();
		try {
		    intranets = data.getIntranets();
		}
		catch(DataException e) {
		    log.error("Home::init() : DataException :\n" + e);
			Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
			return Boolean.FALSE;
		}
		try {
		    admin = Security.isAdmin(login);
		}
		catch(SecurityException e) {
		    log.error("Home::init() : SecurityException :\n" + e);
			Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
			return Boolean.FALSE;
		}
		if(admin && all) {
		    xslParameters.put("all", "true");
		    return Boolean.TRUE;
		}
		for(Iterator i = intranets.iterator();i.hasNext();) {
		    Intranet tmp = (Intranet)i.next();
		    try {
		        if(!Security.isIntranetAccessible(login, tmp.getId())) {
		            i.remove();
		        }
		    }
		    catch(SecurityException e) {
		        log.error("Home::init() : SecurityException :\n" + e);
		    }
		}
		if(!admin && intranets.size() == 1) {
		    Intranet intra = (Intranet)intranets.get(0);
		    getRuntimeData().setParameter("intranet", intra.getId());
		    getRuntimeData().setParameter("folder", intra.getFolder());
		    getMainChannel().redirect(getRuntimeData(), "viewfolder");
		    return Boolean.FALSE;
		}
		getXSLParameter().put("all", "false");
		return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche la liste des intranets accessibles
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("Home::setXML()");
        }
        Collections.sort(intranets);
        StringBuffer xml = new StringBuffer();
        xml.append("<intranets>\n");
        for(Iterator i = intranets.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</intranets>\n");
        if(log.isDebugEnabled()) {
            log.debug("Home::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        return Boolean.TRUE;
    }
    
    /**
     * Etape 4/4 du cyle de vie de la SubChannel
     * Positionne le titre SSL  utiliser
     * Override SubChannel.setOutput() method
     */
    public void setOutput() throws FrameWorkException {
        super.setOutput();
        if(admin) {
            setXSL("admin");
        }
        else {
            setXSL("user");
        }
    }
}
