package org.esupportail.portal.channels.CIntranet.beans;

import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.jasig.portal.utils.XMLEscaper;

/**
 * Folder<br>
 * <br>
 * Classe dfinissant le comportement d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class Folder implements Comparable, XMLSerializable {

    private String id = "";
    private String intranet = "";
    private String name = "";
    private String parentid = "";
    private String date = "";
    
    /**
     * Constructeur
     */
    public Folder() {
    }
    
    /**
     * Retourne l'identifiant
     * @return id L'identifiant
     */
    public String getId() {
        return id;
    }
    
    /**
     * Positionne l'identifiant
     * @param id L'identifiant
     */
    public void setId(String id) {
        this.id = id;
    }
    
    /**
     * Retourne l'intranet
     * @return intranet L'intranet
     */
    public String getIntranet() {
        return intranet;
    }
    
    /**
     * Positionne l'intranet
     * @param intranet L'intranet
     */
    public void setIntranet(String intranet) {
        this.intranet = intranet;
    }
    
    /**
     * Retourne le nom
     * @return name Le nom
     */
    public String getName() {
        return name;
    }
    
    /**
     * Positionne le nom
     * @param name Le nom
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * Retourne le parent
     * @return parentid Le parent
     */
    public String getParentid() {
        return parentid;
    }
    
    /**
     * Positionne le parent
     * @param parentid Le parent
     */
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }
    
    /**
     * Retourne la date
     * @return date La date
     */
    public String getDate() {
        return date;
    }
    
    /**
     * Positionne la date
     * @param date La date
     */
    public void setDate(String date) {
        this.date = date;
    }
    
    /**
     * Compare deux dossiers suivant leur nom
     * Implements Comparable interface
     * @param o Objet  comparer
     */
    public int compareTo(Object o) {
        if(!(o instanceof Folder)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        Folder fol = (Folder)o;
        return getName().compareTo(fol.getName());
    }

    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<folder id=\"" + getId() + "\" intranet=\"" + getIntranet() + "\" ");
        xml.append("name=\"" + XMLEscaper.escape(getName()) + "\" parent=\"" + getParentid() + "\" ");
        xml.append("date=\"" + getDate() + "\" datetext=\"" + XMLEscaper.escape(Date.formatDate(getDate())) + "\" />\n");
        return xml.toString();
    }

}
