package org.esupportail.portal.channels.CIntranet.beans;

import java.util.HashMap;
import java.util.Map;

import org.jasig.portal.utils.XMLEscaper;

/**
 * Ressource<br>
 * <br>
 * Classe dfinissant le comportement d'une ressource de stockage<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */

public class Ressource implements Comparable, XMLSerializable {
	
	private String name = "";
	private String description = "";
	private String classname = "";
	private Map parameters = new HashMap();
	
	/**
	 * Constructeur
	 */
	public Ressource() {
	}

	/**
	 * Retourne le nom
	 * @return name Le nom
	 */
	public String getName() {
		return name;
	}

	/**
	 * Positionne le nom
	 * @param name Le nom
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Retourne la description
	 * @return description La description
	 */
	public String getDescription() {
	    return description;
	}
	
	/**
	 * Positionne la description
	 * @param description La description
	 */
	public void setDescription(String description) {
	    if(description != null) {
	        this.description = description;
	    }
	    else {
	        this.description = "Aucune description";
	    }
	}

	/**
	 * Retourne la classe
	 * @return classname La classe
	 */
	public String getClassname() {
		return classname;
	}

	/**
	 * Positionne la classe
	 * @param classname La classe
	 */
	public void setClassname(String classname) {
		this.classname = classname;
	}
	
	/**
	 * Ajoute un paramtre
	 * @param name Le nom
	 * @param value La valeur
	 */
	public void addParameter(String name, String value) {
		parameters.put(name, value);
	}

	/**
	 * Retourne les paramtres
	 * @return parameters Les paramtres
	 */
	public Map getParameters() {
		return parameters;
	}
	
	/**
     * Compare deux ressources suivant leur nom
     * Implements Comparable interface
     * @param o Objet  comparer
     */
    public int compareTo(Object o) {
        if(!(o instanceof Ressource)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        Ressource r = (Ressource)o;
        return getName().compareTo(r.getName());
    }

    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<ressource name=\"" + getName() + "\" description=\"" + XMLEscaper.escape(getDescription()) + "\" />\n");
        return xml.toString();
    }
}
