package org.esupportail.portal.channels.CIntranet;

import org.esupportail.portal.channels.CAnnuaire.CAnnuaireServant;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Confirm;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;

/**
 * CIntranet<br>
 * <br>
 * Classe principale du canal de consultation<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class CIntranet extends MainChannel {
    
    /**
     * Constructeur
     * @throws PortalException
     */
    public CIntranet() throws PortalException {
        super();
		setConfigActions(Config.getInstance());
		Message.register(this);
		Confirm.register(this);
		setDefaultAction("intranet");
    }
    
    /**
	 * Appel  un canal servant
	 * Override MainChannel.initServant() method
	 * @param servant L'instance du canal servant
	 * @throws PortalException
	 */
	public void initServant(IServant servant) throws PortalException {
		if(servant instanceof CAnnuaireServant) {
		    staticData.setParameter("serverView", Config.getInstance().getDirectories());
			staticData.setParameter("returnServant","single");
		}
		super.initServant(servant);
	}
}
