package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.beans.Ressource;
import org.esupportail.portal.channels.CIntranet.beans.XMLSerializable;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * Accueil<br>
 * <br>
 * Cette classe affiche la liste des intranets<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class Home extends AbstractAction {

    protected static Log log = LogFactory.getLog(Home.class);
    
    private List intranets = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public Home(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Construit la liste des intranets
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Home::init()");
        }
        DataControler data = new DataControler();
        try {
            intranets = data.getIntranets();
        }
        catch(DataException e) {
            log.error("Home::init() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        for(Iterator i = intranets.iterator();i.hasNext();) {
            Intranet tmp = (Intranet)i.next();
            Ressource res = (Ressource)Config.getInstance().getRessources().get(tmp.getRessource());
            tmp.setRessource(res.getDescription());
        }
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche la liste des intranets
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("Home::setXML()");
        }
        Collections.sort(intranets);
        StringBuffer xml = new StringBuffer();
        xml.append("<intranets>\n");
        for(Iterator i = intranets.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</intranets>\n");
        if(log.isDebugEnabled()) {
            log.debug("Home::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        return Boolean.TRUE;
    }
}
