package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.MIME;
import org.esupportail.portal.channels.CIntranet.beans.XMLSerializable;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * MIMETypes<br>
 * <br>
 * Cette classe gre les types MIME<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class MIMETypes extends AbstractAction {

    protected static Log log = LogFactory.getLog(MIMETypes.class);
    
    private List mimes = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public MIMETypes(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche la liste des types MIME
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("MIMETypes::init()");
        }
        DataControler data = new DataControler();
        try {
            mimes = data.getMIMEs();
        }
        catch(DataException e) {
            log.error("MIMETypes::init() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche la liste des types MIME
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("MIMETypes::setXML()");
        }
        Collections.sort(mimes);
        StringBuffer xml = new StringBuffer();
        xml.append("<mimes>\n");
        for(Iterator i = mimes.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</mimes>\n");
        if(log.isDebugEnabled()) {
            log.debug("MIMETypes::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        return Boolean.TRUE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Ajoute un nouveau type MIME
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean addinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("MIMETypes::addinit()");
        }
        String extension = getRuntimeData().getParameter("extension");
        String type = getRuntimeData().getParameter("type");
        
        if(extension == null || type == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        
        if(extension.equals("") || type.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Tous les champs sont obligatoires"), "mimes");
            return Boolean.FALSE;
        }
        
        if(!extension.matches("^\\.[\\w]+$")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Extension non valide, '.zip' est une bonne extension"), "mimes");
            return Boolean.FALSE;
        }
        
        MIME mime = new MIME();
        mime.setId(extension);
        mime.setName(type);
        DataControler data = new DataControler();
        try {
            data.createMIME(mime);
        }
        catch(DataException e) {
            log.error("MIMETypes::addinit() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "mimes");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "mimes");        
        return Boolean.FALSE;
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Supprime un type MIME
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean delinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("MIMETypes::delinit()");
        }
        String id = runtimeData.getParameter("id");
        
        if(id == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        
        if(id.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "mimes");
            return Boolean.FALSE;
        }
        
        DataControler data = new DataControler();
        try {
            data.removeMIME(id);
        }
        catch(DataException e) {
            log.error("MIMETypes::delinit() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "mimes");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "mimes");
        return Boolean.FALSE;
    }
}
