package org.esupportail.portal.channels.CIntranet.actions.intranet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * AbstractAction<br>
 * <br>
 * Dfinit un comportement par dfaut pour toutes les actions du canal de constultation<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public abstract class AbstractAction extends SubChannel {

    protected static Log log = LogFactory.getLog(AbstractAction.class);
    
    protected String userid = null;
    protected Intranet intranet = null;
    protected int level = Security.NONE;
    protected String folderid = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public AbstractAction(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Implmente un comportement par dfaut pour toutes les actions du canal de consultation
     * Si l'utilisateur n'a pas le niveau requis, le canal affiche un message d'erreur
     * @param rd Les runtimeData
     * @return Boolean TRUE si l'utilisateur a le niveau requis, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean initialize(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("AbstractAction::initialize()");
        }
        userid = getMainChannel().getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
        if(getRuntimeData().getParameter("intranet") != null) {
            String intranet = getRuntimeData().getParameter("intranet");
            DataControler data = new DataControler();
            try {
                this.intranet = data.getIntranet(intranet);
                if(!Security.isAdmin(userid)) {
                    if(!Security.isIntranetAccessible(userid, intranet)) {
                        getRuntimeData().setParameter("intranet", (String)null);
                        Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "intranet");
                        return Boolean.FALSE;
                    }
                }
                getMainChannel().getStaticData().put("intranet", this.intranet);
            }
            catch(DataException e) {
                log.error("AbstractAction::initialize() : DataException :\n" + e);
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
                return Boolean.FALSE;
            }
            catch(SecurityException e) {
                log.error("AbstractAction::initialize() : DataException :\n" + e);
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
                return Boolean.FALSE;
            }
        }
        if(getMainChannel().getStaticData().get("intranet") == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        intranet = (Intranet)getMainChannel().getStaticData().get("intranet");
        if(getRuntimeData().getParameter("folder") != null) {
            folderid = getRuntimeData().getParameter("folder");
        }
        else {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        try {
            if(Security.isAdmin(userid)) {
                level = Security.ED_FULL;
            }
            else {
                level = Security.getLevel(userid, folderid);
            }
        }
        catch(SecurityException e) {
            log.error("AbstractAction::initialize() : SecurityException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
            return Boolean.FALSE;
        }
        if(level < getLevel()) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "intranet");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
    
    /**
     * Mthode abstraite  implmenter pour toutes les classes du canal de consultation
     * Indique le niveau requis pour raliser cette action
     * @return level Le niveau requis pour accder  cette action
     */
    public abstract int getLevel();
}
