package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.DocumentFile;
import org.esupportail.portal.channels.CIntranet.beans.MIME;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.PortalException;

/**
 * Download<br>
 * <br>
 * Cette classe prend en charge le tlchargement d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class Download extends AbstractAction implements IMimeResponse {

    protected static Log log = LogFactory.getLog(Download.class);
    
    private InputStream input;
    private DocumentFile doc;
    private String mime;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public Download(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.NONE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Prpare le document  tlcharger
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Download::init()");
        }
        String id = getRuntimeData().getParameter("id");
        if(id == null) {
            log.error("Download::action() : Erreur d'acc\u00E8s \u00E0 la page");
			return Boolean.FALSE;
        }
        DataControler data = new DataControler();
        Document doc = null;
        List mimes = null;
        try {
            doc = data.getDocument(intranet.getId(), id);
            mimes = data.getMIMEs();
        }
        catch(DataException e) {
            log.error("Download::init() : DataException :\n" + e);
            return Boolean.FALSE;
        }
        if(!(doc instanceof DocumentFile)) {
            log.error("Download::init() : Erreur d'acc\u00E8");
            return Boolean.FALSE;
        }
        this.doc = (DocumentFile)doc;
        for(Iterator i = mimes.iterator();i.hasNext();) {
            MIME tmp = (MIME)i.next();
            if(tmp.getId().equals(this.doc.getExtension())) {
                mime = tmp.getName();
            }
        }
        IStorageControler store = StorageFactory.make(intranet.getRessource());
        try {
            input = store.loadDocument(intranet.getId(), this.doc);
        }
        catch(StorageException e) {
            log.error("Download::init() : StorageException :\n" + e);
        }
        return Boolean.FALSE;
    }
    
    /**
     * Nettoyage du canal
     * Override Subchannel.clearChannel method
     */
    public void clearChannel() {
        super.clearChannel();
        input = null;
        doc = null;
        mime = null;
    }
        
    /**
     * Retourne le type MIME du document
     * Implements IMimeResponse interface
     * @return type Le type MIME
     */
    public String getContentType() {
        if(log.isDebugEnabled()) {
            log.debug("Download::getContentType()");
        }
        return mime;
    }

    /**
     * Retourne le flux de lecture du fichier
     * Implements IMimeResponse interface
     * @return input Le flux (null si aucun flux) 
     */
    public InputStream getInputStream() throws IOException {
        if(log.isDebugEnabled()) {
            log.debug("Download::getInputStream()");
        }
        return input;
    }

    /**
     * Construit le flux de sortie du fichier
     * Implements IMimeResponse interface
     * @param out Le flux de sortie
     */
    public void downloadData(OutputStream out) throws IOException {
        if(log.isDebugEnabled()) {
            log.debug("Download::downloadData()");
        }
        out.close();
    }

    /**
     * Retourne le nom du fichier
     * Implements IMimeResponse interface
     * Warning : mthode inutilise
     * @return name Le nom du fichier
     */
    public String getName() {
        if(log.isDebugEnabled()) {
            log.debug("Download::getName()");
        }
        String result = null;
		result = doc.getFile().replaceAll(" ", "_");
		result = result.replaceAll("[\u00E0\u00E1\u00E2\u00E3\u00E4]", "a");
		result = result.replaceAll("[\u00E7]", "c");
		result = result.replaceAll("[\u00E8\u00E9\u00EA\u00EB]", "e");
		result = result.replaceAll("[\u00EC\u00ED\u00EE\u00EF]", "i");
		result = result.replaceAll("[\u00F1]", "n");
		result = result.replaceAll("[\u00F2\u00F3\u00F4\u00F5\u00F6]", "o");
		result = result.replaceAll("[\u00F9\u00FA\u00FB\u00FC]", "u");
		
		result = result.replaceAll("[\u00C0\u00C1\u00C2\u00C3\u00C4]", "A");
		result = result.replaceAll("[\u00C7]", "C");
		result = result.replaceAll("[\u00C8\u00C9\u00CA\u00CB]", "E");
		result = result.replaceAll("[\u00CC\u00CD\u00CE\u00CF]", "I");
		result = result.replaceAll("[\u00D1]", "N");
		result = result.replaceAll("[\u00D2\u00D3\u00D4\u00D5\u00D6]", "O");
		result = result.replaceAll("[\u00D9\u00DA\u00DB\u00DC]", "U");
		
		return result;
    }

    /**
     * Retourne la tables des headers HTTP
     * Implements IMimeResponse interface
     * @return map Les headers
     */
    public Map getHeaders() {
        if(log.isDebugEnabled()) {
            log.debug("Download::getHeaders()");
        }
        HashMap map = new HashMap();
		map.put("Content-disposition", "attachment; filename=" + getName());
		return map;
    }

    /**
     * Indique une erreur en cours de tlchargement
     * Implements IMimeResponse interface
     * @param e L'exception rencontre
     */
    public void reportDownloadError(Exception e) {
        if(log.isDebugEnabled()) {
            log.debug("Download::reportDownloadError()");
        }
        log.error("Download::reportDownloadError() : Exception :\n" + e);
    }
}
