package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * HideDocuments<br>
 * <br>
 * Cette classe prend en charge l'affichage/masquage de plusieurs documents<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class HideDocuments extends AbstractAction {

    protected static Log log = LogFactory.getLog(HideDocuments.class);
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public HideDocuments(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.ED_FULL;
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Cache des documents
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean hide(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("HideDocuments::hide()");
        }
        String [] ids = getRuntimeData().getParameterValues("selected");
        if(ids == null) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Aucun document s\u00E9lectionn\u00E9"), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        DataControler data = new DataControler();
        for(int i=0;i<ids.length;i++) {
            String id = ids[i];
            if(id != null && !id.equals("")) {
                Document doc = null;
                try {
                    doc = data.getDocument(intranet.getId(), id);
                    if(!doc.isPendingDeletion() && !doc.isPendingModification() && doc.isValid() && doc.isVisible()) {
                        data.setDocumentVisible(intranet.getId(), id, false);
                    }
                }
                catch(DataException e) {
                    log.error("HideDocuments::hide() : DataException:\n" + e);
                }
            }
        }
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche des documents
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean unhide(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("HideDocuments::unhide()");
        }
        String [] ids = getRuntimeData().getParameterValues("selected");
        if(ids == null) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Aucun document s\u00E9lectionn\u00E9"), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        DataControler data = new DataControler();
        for(int i=0;i<ids.length;i++) {
            String id = ids[i];
            if(id != null && !id.equals("")) {
                Document doc = null;
                try {
                    doc = data.getDocument(intranet.getId(), id);
                    if(!doc.isPendingDeletion() && !doc.isPendingModification() && doc.isValid() && !doc.isVisible()) {
                        data.setDocumentVisible(intranet.getId(), id, true);
                    }
                }
                catch(DataException e) {
                    log.error("HideDocuments::unhide() : DataException:\n" + e);
                }
            }
        }
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.FALSE;
    }
}
