package org.esupportail.portal.channels.CIntranet.beans;

import java.util.Comparator;

/**
 * DocumentDateComparator<br>
 * <br>
 * Cette classe prend en compte le tri des documents en fonction de la date<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class DocumentDateComparator implements Comparator {

    /**
     * Constructeur
     */
    public DocumentDateComparator() {
        super();
    }

    /**
     * Compare deux documents en fonction de la date
     * Implements Comparator.compare() method
     * @param o0 Le premier document
     * @param o1 Le deuxime document
     * @return diff
     */
    public int compare(Object o0, Object o1) {
        if(!(o0 instanceof Document) || !(o1 instanceof Document)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        Document doc0 = (Document)o0;
        Document doc1 = (Document)o1;
        return doc0.getDate().compareTo(doc1.getDate());
    }
}
