package org.esupportail.portal.channels.CIntranet.beans;

import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.jasig.portal.utils.XMLEscaper;

/**
 * DocumentFile<br>
 * <br>
 * Document de type fichier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class DocumentFile extends Document {

    private String file = "";
    private String extension = "";
    
    /**
     * Constructeur
     */
    public DocumentFile() {
        super();
        setType(Document.FILE);
    }

    /**
     * Retourne le nom du fichier
     * @return file Le nom du fichier
     */
    public String getFile() {
        return file;
    }
    
    /**
     * Positionne le nom du fichier
     * @param file Le nom du fichier
     */
    public void setFile(String file) {
        this.file = file;
    }

    /**
     * Retourne l'extension
     * @return extension L'extension
     */
    public String getExtension() {
        return extension;
    }
    
    /**
     * Positionne l'extension
     * @param extension L'extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }
    
    /**
     * Teste l'galit de deux documents
     * Override Object.equals() method
     * @param o Objet  tester
     */
    public boolean equals(Object o) {
        if(!(o instanceof DocumentFile)) {
            return false;
        }
        DocumentFile doc = (DocumentFile)o;
        return (getType() == doc.getType()) && getName().equals(doc.getName()) && getDescription().equals(doc.getDescription()) && getFile().equals(doc.getFile());
    }

    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<document type=\"file\" id=\"" + getId() + "\" folder=\"" + getFolderid() + "\" ");
        xml.append("name=\"" + XMLEscaper.escape(getName()) + "\" description=\"" + XMLEscaper.escape(getDescription()) + "\" ");
        xml.append("author=\"" + getAuthor() + "\" date=\"" + getDate() + "\" datetext=\"" + Date.formatDate(getDate()) + "\" ");
        xml.append("validity=\"" + getValidityDate() + "\" validitytext=\"" + Date.formatDate(getValidityDate()) + "\" ");
        xml.append("valid=\"" + isValid() + "\" visible=\"" + isVisible() + "\" modified=\"" + isPendingModification() + "\" ");
        xml.append("deleted=\"" + isPendingDeletion() + "\" file=\"" + XMLEscaper.escape(getFile()) + "\" ");
        xml.append("extension=\"" + getExtension() + "\" order=\"" + getOrder() + "\" perimed=\"" + isPerimed() + "\" ");
        xml.append("validityinput=\"" + getValidityInput() + "\" />\n");
        return xml.toString();
    }

}
