package org.esupportail.portal.channels.CIntranet.beans;

/**
 * Entity<br>
 * <br>
 * Cette classe dfini le comportement d'une entit abstraite<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public abstract class Entity implements Comparable, XMLSerializable {

    private String id = "";
    private String name = "";
    
    /**
     * Constructeur
     */
    public Entity() {
    }
    
    /**
     * Retourne l'identifiant
     * @return id L'identifiant
     */
    public String getId() {
        return id;
    }
    
    /**
     * Positionne l'identifiant
     * @param id L'identifiant
     */
    public void setId(String id) {
        this.id = id;
    }
    
    /**
     * Retourne le nom
     * @return name Le nom
     */
    public String getName() {
        return name;
    }
    
    /**
     * Positionne le nom
     * @param name Le nom
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * Teste l'galit de deux entits
     * Override Object.equals() method
     * @param o Objet  tester
     */
    public abstract boolean equals(Object o);
    
    /**
     * Compare deux entits suivant leur nom ou leur identifiant
     * Implements Comparable interface
     * @param o Objet  comparer
     */
    public int compareTo(Object o) {
        if(!(o instanceof Entity)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        Entity e = (Entity)o;
        if(getName().equals("") || e.getName().equals("")) {
            return getId().compareTo(e.getId());
        }
        return getName().compareTo(e.getName());
    }

    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public abstract String toXMLString();

}
