package org.esupportail.portal.channels.CIntranet.beans;

import org.esupportail.portal.channels.CIntranet.security.Security;


/**
 * Grant<br>
 * <br>
 * Cette classe dfinit le comportement d'un droit<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class Grant implements Comparable, XMLSerializable {

    private String folderid = "";
    private int level = Security.NONE;
    private Entity granted = null;
    private boolean extended = false;
    private boolean notification = false;

    /**
     * Constructeur
     */
    public Grant() {
    }
    
    /**
     * Retourne l'identifiant du dossier
     * @return folderid L'identifiant du dossier
     */
    public String getFolderid() {
        return folderid;
    }
    
    /**
     * Positionne l'identifiant du dossier
     * @param folderid L'identifiant du dossier
     */
    public void setFolderid(String folderid) {
        this.folderid = folderid;
    }
    
    /**
     * Retourne le type de droit
     * @return level Le type
     */
    public int getLevel() {
        return level;
    }
    
    /**
     * Positionne le type de droit
     * @param level le type
     */
    public void setLevel(int level) {
        this.level = level;
    }
    
    /**
     * Retourne l'entit
     * @return granted L'entit
     */
    public Entity getGranted() {
        return granted;
    }
    
    /**
     * Positionne l'entit
     * @param granted l'entit
     */
    public void setGranted(Entity granted) {
        this.granted = granted;
    }
    
    /**
     * Si le droit est hrit
     * @return extended true | false
     */
    public boolean isExtended() {
        return extended;
    }
    
    /**
     * Positionne l'hritage
     * @param extended l'hritage
     */
    public void setExtended(boolean extended) {
        this.extended = extended;
    }
    
    /**
     * Si la notification est active
     * @return notification true | false
     */
    public boolean isNotification() {
        return notification;
    }
    
    /**
     * Positionne la notification
     * @param notification La notification
     */
    public void setNotification(boolean notification) {
        this.notification = notification;
    }
    
    /**
     * Compare deux entits suivant leur nom ou leur identifiant
     * Implements Comparable interface
     * @param o Objet  comparer
     */
    public int compareTo(Object o) {
        if(!(o instanceof Grant)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        Grant g = (Grant)o;
        return getLevel() - g.getLevel();
    }
    
    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<grant folder=\"" + getFolderid() + "\" level=\"" + getLevel() + "\" ");
        xml.append("extended=\"" + isExtended() + "\" notification=\"" + isNotification() + "\" ");
        if(getGranted() instanceof Group) {
            xml.append("type=\"group\">\n");
        }
        else {
            xml.append("type=\"user\">\n");
        }
        xml.append(getGranted().toXMLString());
        xml.append("</grant>\n");
        return xml.toString();
    }
}
