package org.esupportail.portal.channels.CIntranet.beans;

/**
 * MIME<br>
 * <br>
 * Classe dfinissant le comportement d'un type MIME<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class MIME extends Entity {

    /**
     * Constructeur
     */
    public MIME() {
    }
        
    /**
     * Teste l'galit de deux types MIME
     * Implements Entity abstract class
     * @param o Objet  tester
     */
    public boolean equals(Object o) {
        if(!(this instanceof MIME && o instanceof MIME)) {
            return false;
        }
        Entity e = (Entity)o;
        return getId().equals(e.getId());
    }
    
    /**
     * Compare deux types MIME suivant leur extension
     * Override Entity.compareTo() method
     * @param o Objet  comparer
     */
    public int compareTo(Object o) {
        if(!(o instanceof MIME)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        MIME e = (MIME)o;
        return getId().compareTo(e.getId());
    }
    
    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<mime id=\"" + getId() + "\" name=\"" + getName() + "\" />\n");
        return xml.toString();
    }
}
