package org.esupportail.portal.channels.CIntranet.config;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Ressource;
import org.esupportail.portal.utils.channels.ConfigChannel;

/**
 * Config<br>
 * <br>
 * Classe permettant la lecture du fichier de configuration<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */

public class Config extends ConfigChannel {

    protected static final Log log = LogFactory.getLog(Config.class);
    private static Config singleton = null;
    
    private Map ressources;
	private String sizeUpload;
	private String directories;
	private String smtp;
	private String from;
	private String channelName;

	/**
	 * Retourne l'instance de la classe Config
	 * @return singleton L'instance unique
	 */
	public static Config getInstance() {
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}
	
	/**
	 * Constructeur
	 */
	private Config() {
	}
	
	/**
	 * Retourne le fichier de configuration
	 * @return Le fichier
	 */
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CIntranet/CIntranet.xml";
	}
	
	/**
	 * Rgles de parsing propres au canal Intranet
	 */
	protected void customDigester() {
	    if(log.isDebugEnabled()) {
		    log.debug("Config::customDigester()");
		}
	    		
		// Ressources de stockage
		
		ressources = new HashMap();
		
		dig.addObjectCreate("config/storages/storage", Ressource.class);
		dig.addSetProperties("config/storages/storage");
		
			dig.addCallMethod("config/storages/storage/parameters/parameter", "addParameter", 2);
			dig.addCallParam("config/storages/storage/parameters/parameter", 0, "name");
			dig.addCallParam("config/storages/storage/parameters/parameter", 1, "value");
		
		dig.addSetNext("config/storages/storage", "addRessource");
		
		dig.addCallMethod("config/cannuaire", "setDirectories", 1);
		dig.addCallParam("config/cannuaire", 0, "directories");
		
		dig.addCallMethod("config/fileupload", "setSizeUpload", 1);
		dig.addCallParam("config/fileupload", 0, "size");
		
		dig.addCallMethod("config/notification", "setMailParameters", 3);
		dig.addCallParam("config/notification", 0, "smtp");
		dig.addCallParam("config/notification", 1, "from");
		dig.addCallParam("config/notification", 2, "channel");
	}
	
	/**
	 * Ajout d'une ressource physique de stockage
	 * @param res
	 */
	public void addRessource(Ressource res) {
	    if(log.isDebugEnabled()) {
		    log.debug("Config::addRessource() : " + res.getName() + " " + res.getClassname());
	    }
		ressources.put(res.getName(), res);
	}
	
	/**
	 * Retourne la liste des ressources de stockage
	 * @return storageControlers La liste des ressources
	 */
	public Map getRessources() {
	    if(log.isDebugEnabled()) {
		    log.debug("Config::getRessources()");
	    }
		return ressources;
	}

	/**
	 * Positionne la taille maximale uploadable
	 * @param size La taille en octets
	 */
	public void setSizeUpload(String size) {
		sizeUpload = size;
	}

	/**
	 * Retourne la taille maximale uploadable
	 * @return sizeUpload La taille en octets
	 */
	public int getSizeUpload() {
		return new Integer(sizeUpload).intValue();
	}

	/**
	 * Retourne la liste des annuaires  utiliser
	 * @return directories La liste
	 */
	public String getDirectories() {
	    return directories;
	}
	
	/**
	 * Positionne la liste des annuaires  utiliser
	 * @param liste La liste
	 */
	public void setDirectories(String liste) {
	    directories = liste;
	}

	public void setMailParameters(String smtp, String from, String channel) {
	    this.smtp = smtp;
	    this.from = from;
	    this.channelName = channel;
	}
	
	public String getSMTP() {
	    return smtp;
	}
	
	public String getFROM() {
	    return from;
	}
	
	public String getChannelFunctionnalName() {
	    return channelName;
	}
}