package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.DocumentFile;
import org.esupportail.portal.channels.CIntranet.beans.DocumentLink;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.RDBMServices;

/**
 * DocumentAccess<br>
 * <br>
 * Ralise les oprations relatives aux documents dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class DocumentAccess {

    protected static Log log = LogFactory.getLog(DocumentAccess.class);
    
    /**
     * Retourne un document
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du document
     * @return doc Le document
     * @throws DataException
     */
    public static Document getDocument(Query query, String intranet, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::getDocument()");
        }
        
        Document doc = null;
        String sql = "SELECT * FROM INT_DOCUMENT WHERE ID_INT = '" + intranet + "' AND ID_DOC = " + id;
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if(!result.next()) {
                log.debug("DocumentAccess::getDocument() : Aucun document ayant pour id " + id);
                throw new DataException("Impossible d'acc\u00E9der \u00E0 ce document");
            }
            if(result.getString("TYPE_DOC").equals("F")) {
                DocumentFile df = new DocumentFile();
                df.setFile(result.getString("FILE_DOC"));
                df.setExtension(result.getString("EXT_DOC"));
                doc = df;
            }
            else {
                DocumentLink dl = new DocumentLink();
                dl.setUrl(result.getString("URL_DOC"));
                doc = dl;
            }
            doc.setId(result.getString("ID_DOC"));
            doc.setIntranet(result.getString("ID_INT"));
            doc.setFolderid(result.getString("ID_FOL"));
            doc.setName(result.getString("NAME_DOC"));
            doc.setDescription(result.getString("DES_DOC"));
            doc.setAuthor(result.getString("AUT_DOC"));
            doc.setDate(result.getString("DATE_DOC"));
            doc.setValidityDate(result.getString("DATEVAL_DOC"));
            doc.setOrder(result.getString("ORDER_DOC"));
            if(result.getString("VALID_DOC").equals("1")) {
                doc.setValid(true);
            }
            else {
                doc.setValid(false);
            }
            if(result.getString("PENDM_DOC").equals("1")) {
                doc.setPendingModification(true);
            }
            else {
                doc.setPendingModification(false);
            }
            if(result.getString("PENDD_DOC").equals("1")) {
                doc.setPendingDeletion(true);
            }
            else {
                doc.setPendingDeletion(false);
            }
            if(result.getString("HIDDEN_DOC").equals("1")) {
                doc.setVisible(false);
            }
            else {
                doc.setVisible(true);
            }
        }
        catch(SQLException e) {
            log.error("DocumentAccess::getDocument() : " + e);
			log.error("DocumentAccess::getDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture du document");
        }
        return doc;
    }
    
    /**
     * Retourne l'identifiant du document li
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du document pre
     * @return id L'identifiant
     * @throws DataException
     */
    public static String getLinkedDocument(Query query, String intranet, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::getLinkedDocument()");
        }
        String sql = "SELECT ID_DOCMOD FROM INT_DOCUMENT WHERE ID_INT = '" + intranet + "' AND ID_DOC = " + id;
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if(!result.next()) {
                log.debug("DocumentAccess::getLinkedDocument() : Aucun document ayant pour id " + id);
                throw new DataException("Impossible d'acc\u00E9der \u00E0 ce document");
            }
            return result.getString("ID_DOCMOD");
        }
        catch(SQLException e) {
            log.error("DocumentAccess::getLinkedDocument() : " + e);
			log.error("DocumentAccess::getLinkedDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture du document");
        }
    }
    
    /**
     * Positionne l'identifiant du document li
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du document pre
     * @param idl L'identifiant du document li
     * @throws DataException
     */
    public static void setLinkedDocument(Query query, String intranet, String id, String idl) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::setLinkedDocument()");
        }
        String sql = "UPDATE INT_DOCUMENT SET ID_DOCMOD = " + idl + " WHERE ID_INT = '" + intranet + "' AND ID_DOC = " + id;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::setLinkedDocument() : " + e);
			log.error("DocumentAccess::setLinkedDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la modification du document");
        }
    }
    
    /**
     * Supprime le lien entre documents lis
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du document pre
     * @throws DataException
     */
    public static void unlinkDocument(Query query, String intranet, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::unlinkDocument()");
        }
        String sql = "UPDATE INT_DOCUMENT SET ID_DOCMOD = 0 WHERE ID_INT = '" + intranet + "' AND ID_DOC = " + id;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::unlinkDocument() : " + e);
			log.error("DocumentAccess::unlinkDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la modification du document");
        }
    }
    
    /**
     * Retourne la liste des documents d'un dossier
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du dossier
     * @return docs La liste des documents
     * @throws DataException
     */
    public static List getDocuments(Query query, String intranet, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::getDocuments()");
        }
        List docs = new ArrayList();
        String sql = "SELECT * FROM INT_DOCUMENT WHERE ID_INT = '" + intranet + "' AND ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            while(result.next()) {
                Document doc = null;
                if(result.getString("TYPE_DOC").equals("F")) {
                    DocumentFile df = new DocumentFile();
                    df.setFile(result.getString("FILE_DOC"));
                    df.setExtension(result.getString("EXT_DOC"));
                    doc = df;
                }
                else {
                    DocumentLink dl = new DocumentLink();
                    dl.setUrl(result.getString("URL_DOC"));
                    doc = dl;
                }
                doc.setId(result.getString("ID_DOC"));
                doc.setIntranet(result.getString("ID_INT"));
                doc.setFolderid(result.getString("ID_FOL"));
                doc.setName(result.getString("NAME_DOC"));
                doc.setDescription(result.getString("DES_DOC"));
                doc.setAuthor(result.getString("AUT_DOC"));
                doc.setDate(result.getString("DATE_DOC"));
                doc.setValidityDate(result.getString("DATEVAL_DOC"));
                doc.setOrder(result.getString("ORDER_DOC"));
                if(result.getString("VALID_DOC").equals("1")) {
                    doc.setValid(true);
                }
                else {
                    doc.setValid(false);
                }
                if(result.getString("PENDM_DOC").equals("1")) {
                    doc.setPendingModification(true);
                }
                else {
                    doc.setPendingModification(false);
                }
                if(result.getString("PENDD_DOC").equals("1")) {
                    doc.setPendingDeletion(true);
                }
                else {
                    doc.setPendingDeletion(false);
                }
                if(result.getString("HIDDEN_DOC").equals("1")) {
                    doc.setVisible(false);
                }
                else {
                    doc.setVisible(true);
                }
                docs.add(doc);
            }
        }
        catch(SQLException e) {
            log.error("DocumentAccess::getDocuments() : " + e);
			log.error("DocumentAccess::getDocuments() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des documents");
        }
        return docs;
    }
    
    /**
     * Cre un nouveau document
     * @param query La connexion  utiliser
     * @param doc Le document  crer
     * @throws DataException
     */
    public static void createDocument(Query query, Document doc) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::createDocument()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO INT_DOCUMENT(ID_DOC, ID_INT, ID_FOL, NAME_DOC, DES_DOC, AUT_DOC, DATE_DOC, ");
        sql.append("DATEVAL_DOC, ORDER_DOC, VALID_DOC, PENDM_DOC, PENDD_DOC, HIDDEN_DOC, ID_DOCMOD, TYPE_DOC, ");
        if(doc instanceof DocumentFile) {
            sql.append("FILE_DOC, EXT_DOC) VALUES(");
        }
        else {
            sql.append("URL_DOC) VALUES(");
        }
        sql.append(doc.getId() + ", ");
        sql.append("'" + doc.getIntranet() + "', ");
        sql.append(doc.getFolderid() + ", ");
        sql.append("'" + RDBMServices.sqlEscape(doc.getName()) + "', ");
        sql.append("'" + RDBMServices.sqlEscape(doc.getDescription()) + "', ");
        sql.append("'" + doc.getAuthor() + "', ");
        sql.append("'" + doc.getDate() + "', ");
        sql.append("'" + doc.getValidityDate() + "', ");
        sql.append(doc.getOrder() + ", ");
        if(doc.isValid()) {
            sql.append("'1', ");
        }
        else {
            sql.append("'0', ");
        }
        if(doc.isPendingModification()) {
            sql.append("'1', ");
        }
        else {
            sql.append("'0', ");
        }
        if(doc.isPendingDeletion()) {
            sql.append("'1', ");
        }
        else {
            sql.append("'0', ");
        }
        if(doc.isVisible()) {
            sql.append("'0', ");
        }
        else {
            sql.append("'1', ");
        }
        sql.append("0, ");
        if(doc instanceof DocumentFile) {
            DocumentFile d = (DocumentFile)doc;
            sql.append("'F', ");
            sql.append("'" + RDBMServices.sqlEscape(d.getFile()) + "', ");
            sql.append("'" + d.getExtension() + "')");
        }
        else {
            DocumentLink d = (DocumentLink)doc;
            sql.append("'L', ");
            sql.append("'" + RDBMServices.sqlEscape(d.getUrl()) + "')");
        }
        try {
            query.setSql(sql.toString());
            query.insert();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::createDocument() : " + e);
            log.error("DocumentAccess::createDocument() : SQL : " + sql);
            throw new DataException("Erreur lors de la cr\u00E9ation du document");
        }
    }
    
    /**
     * Modifie un document existant
     * @param query La connexion  utiliser
     * @param doc Le document  modifier
     * @throws DataException
     */
    public static void updateDocument(Query query, Document doc) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::createDocument()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE INT_DOCUMENT SET NAME_DOC = '" + RDBMServices.sqlEscape(doc.getName()) + "', ");
        sql.append("DES_DOC = '" + RDBMServices.sqlEscape(doc.getDescription()) + "', ");
        sql.append("DATEVAL_DOC = '" + doc.getValidityDate() + "', ");
        if(doc instanceof DocumentFile) {
            DocumentFile d = (DocumentFile)doc;
            sql.append("FILE_DOC = '" + RDBMServices.sqlEscape(d.getFile()) + "', ");
            sql.append("EXT_DOC = '" + d.getExtension() + "' ");
        }
        else {
            DocumentLink d = (DocumentLink)doc;
            sql.append("URL_DOC = '" + RDBMServices.sqlEscape(d.getUrl()) + "' ");
        }
        sql.append("WHERE ID_INT = '" + doc.getIntranet() + "' AND ID_DOC = " + doc.getId());
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::updateDocument() : " + e);
		    log.error("DocumentAccess::updateDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la la mise \u00E0 jour du document");
        }
    }
    
    /**
     * Supprime un document
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du document
     * @throws DataException
     */
    public static void removeDocument(Query query, String intranet, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::removeDocument()");
        }
        String sql = "DELETE FROM INT_DOCUMENT WHERE ID_INT = '" + intranet + "' AND ID_DOC = " + id;
        try {
            query.setSql(sql);
            query.delete();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::removeDocument() : " + e);
		    log.error("DocumentAccess::removeDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la la suppression du document");
        }
    }
    
    /**
     * Supprime tous les documents d'un dossier
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du dossier
     * @throws DataException
     */
    public static void removeDocuments(Query query, String intranet, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::removeDocuments()");
        }
        String sql = "DELETE FROM INT_DOCUMENT WHERE ID_INT = '" + intranet + "' AND ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.delete();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::removeDocuments() : " + e);
		    log.error("DocumentAccess::removeDocuments() : SQL : " + sql);
			throw new DataException("Erreur lors de la la suppression des documents");
        }
    }
    
    /**
     * Positionne la validit d'un document
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du document
     * @param valid La validit
     * @throws DataException
     */
    public static void setValid(Query query, String intranet, String id, boolean valid) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::setValid()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE INT_DOCUMENT SET VALID_DOC = ");
        if(valid) {
            sql.append("'1' ");
        }
        else {
            sql.append("'0' ");
        }
        sql.append("WHERE ID_INT = '" + intranet + "' AND ID_DOC = " + id);
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::setValid() : " + e);
		    log.error("DocumentAccess::setValid() : SQL : " + sql);
			throw new DataException("Erreur lors de la validation / invalidation du document");
        }
    }
    
    /**
     * Positionne la visibilit d'un document
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du document
     * @param visible La visibilit du document
     * @throws DataException
     */
    public static void setVisible(Query query, String intranet, String id, boolean visible) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::setVisible()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE INT_DOCUMENT SET HIDDEN_DOC = ");
        if(visible) {
            sql.append("'0' ");
        }
        else {
            sql.append("'1' ");
        }
        sql.append("WHERE ID_INT = '" + intranet + "' AND ID_DOC = " + id);
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::setVisible() : " + e);
		    log.error("DocumentAccess::setVisible() : SQL : " + sql);
			throw new DataException("Erreur lors du masquage / affichage du document");
        }
    }
    
    /**
     * Positionne une modification en cours
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du document
     * @param modif La modification
     * @throws DataException
     */
    public static void setPendingModification(Query query, String intranet, String id, boolean modif) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::setPendingModification()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE INT_DOCUMENT SET PENDM_DOC = ");
        if(modif) {
            sql.append("'1' ");
        }
        else {
            sql.append("'0' ");
        }
        sql.append("WHERE ID_INT = '" + intranet + "' AND ID_DOC = " + id);
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::setPendingModification() : " + e);
		    log.error("DocumentAccess::setPendingModification() : SQL : " + sql);
			throw new DataException("Erreur lors de la modification du document");
        }
    }
    
    /**
     * Positionne une suppression en cours
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du document
     * @param delete La suppression
     * @throws DataException
     */
    public static void setPendingDeletion(Query query, String intranet, String id, boolean delete) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::setPendingDeletion()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE INT_DOCUMENT SET PENDD_DOC = ");
        if(delete) {
            sql.append("'1' ");
        }
        else {
            sql.append("'0' ");
        }
        sql.append("WHERE ID_INT = '" + intranet + "' AND ID_DOC = " + id);
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::setPendingDeletion() : " + e);
		    log.error("DocumentAccess::setPendingDeletion() : SQL : " + sql);
			throw new DataException("Erreur lors de la modification du document");
        }
    }
    
    /**
     * Teste si un document existe dj
     * @param query La connexion  utiliser
     * @param doc Le document  tester
     * @return boolean True si le document existe, false sinon
     * @throws DataException
     */
    public static boolean documentExist(Query query, Document doc) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::documentExist()");
        }
        String sql = "SELECT ID_DOC FROM INT_DOCUMENT WHERE DES_DOC = '" + RDBMServices.sqlEscape(doc.getDescription()) + "' AND ID_INT = '" + doc.getIntranet() + "' AND ID_FOL = " + doc.getFolderid();
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            return rs.next();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::documentExist() : " + e);
		    log.error("DocumentAccess::documentExist() : SQL : " + sql);
			throw new DataException("Erreur lors de la v\u00E9rification d'existence");
        }
    }
    
    /**
     * Retourne le prochain identifiant de document
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @return L'identifiant suivant
     * @throws DataException
     */
    public static String getNextDocument(Query query, String intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DocumentAccess::getNextDocument()");
        }
        String res = null;
        String sql = "SELECT ID_DOC FROM INT_INTRANET WHERE ID_INT = '" + intranet + "'";
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            rs.next();
            res = rs.getString("ID_DOC");
            sql = "UPDATE INT_INTRANET SET ID_DOC = ID_DOC + 1 WHERE ID_INT = '" + intranet + "'";
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("DocumentAccess::getNextDocument() : " + e);
		    log.error("DocumentAccess::getNextDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la g\u00E9n\u00E9ration d'identifiant");
        }
        return res;
    }
}