package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.FolderTree;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.RDBMServices;

/**
 * FolderAccess<br>
 * <br>
 * Ralise les oprations relatives aux dossiers dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class FolderAccess {
    
    protected static Log log = LogFactory.getLog(FolderAccess.class);
    
    /**
     * Retourne un dossier
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @return folder Le dossier
     * @throws DataException
     */
    public static Folder getFolder(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("FolderAccess::getFolder()");
        }
        Folder res = null;
        String sql = "SELECT * FROM INT_FOLDER WHERE ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            if(!rs.next()) {
                log.debug("FolderAccess::getFolder() : Aucun dossier ayant pour id " + id);
                throw new DataException("Impossible d'acc\u00E9der \u00E0 ce dossier");
            }
            res = new Folder();
            res.setId(rs.getString("ID_FOL"));
            res.setIntranet(rs.getString("ID_INT"));
            res.setName(rs.getString("NAME_FOL"));
            res.setParentid(rs.getString("PARENT_FOL"));
            res.setDate(rs.getString("DATE_FOL"));
        }
        catch(SQLException e) {
            log.error("FolderAccess::getFolder() : " + e);
			log.error("FolderAccess::getFolder() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture du dossier");
        }
        return res;
    }
    
    /**
     * Retourne la liste des sous-dossiers d'un dossier
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier pre
     * @return folders La liste des dossiers
     * @throws DataException
     */
    public static List getFolders(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("FolderAccess::getFolders()");
        }
        List res = new ArrayList();
        String sql = "SELECT * FROM INT_FOLDER WHERE PARENT_FOL = " + id;
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            while(rs.next()) {
                Folder tmp = new Folder();
                tmp.setId(rs.getString("ID_FOL"));
                tmp.setIntranet(rs.getString("ID_INT"));
                tmp.setName(rs.getString("NAME_FOL"));
                tmp.setParentid(rs.getString("PARENT_FOL"));
                tmp.setDate(rs.getString("DATE_FOL"));
                res.add(tmp);
            }
        }
        catch(SQLException e) {
            log.error("FolderAccess::getFolders() : " + e);
			log.error("FolderAccess::getFolders() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des dossiers");
        }
        return res;
    }
    
    /**
	 * Retourne la liste de tous les sous-dossiers d'un dossier (rcursif)
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return folders La liste des sous-dossiers
	 * @throws DataException
	 */
	public static List getFolderChildren(Query query, String id) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("FolderAccess::getFolderChildren()");
	    }
	    
	    List res = new ArrayList();
		List children = new ArrayList();
		
		res = getFolders(query, id);
		
		for(Iterator i = res.iterator();i.hasNext();) {
			Folder tmp = (Folder)i.next();
			children.addAll(getFolderChildren(query, tmp.getId()));
		}
		res.addAll(children);
		return res;
	}
    
    /**
     * Cre un dossier
     * @param query La connexion  utiliser
     * @param folder Le dossier  crer
     * @throws DataException
     */
    public static void createFolder(Query query, Folder folder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("FolderAccess::createFolder()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO INT_FOLDER(ID_FOL, ID_INT, NAME_FOL, PARENT_FOL, DATE_FOL) VALUES(");
        sql.append(folder.getId() + ", ");
        sql.append("'" + folder.getIntranet() + "', ");
        sql.append("'" + RDBMServices.sqlEscape(folder.getName()) + "', ");
        sql.append(folder.getParentid() + ", ");
        sql.append("'" + folder.getDate() + "')");
        try {
            query.setSql(sql.toString());
            query.insert();
        }
        catch(SQLException e) {
            log.error("FolderAccess::createFolder() : " + e);
			log.error("FolderAccess::createFolder() : SQL : " + sql);
			throw new DataException("Erreur lors de la cr\u00E9ation du dossier");
        }
    }
    
    /**
     * Modifie un dossier existant
     * @param query La connexion  utiliser
     * @param folder Le dossier  modifier
     * @throws DataException
     */
    public static void updateFolder(Query query, Folder folder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("FolderAccess::updateFolder()");
        }
        String sql = "UPDATE INT_FOLDER SET NAME_FOL = '" + RDBMServices.sqlEscape(folder.getName()) +"' WHERE ID_FOL = " + folder.getId();
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("FolderAccess::updateFolder() : " + e);
			log.error("FolderAccess::updateFolder() : SQL : " + sql);
			throw new DataException("Erreur lors de la modification du dossier");
        }
    }
    
    /**
     * Modifie la date d'un dossier
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param date La date
     * @throws DataException
     */
    public static void updateFolderDate(Query query, String id, String date) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("FolderAccess::updateFolderDate()");
        }
        String sql = "UPDATE INT_FOLDER SET DATE_FOL = '" + date +"' WHERE ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("FolderAccess::updateFolderDate() : " + e);
			log.error("FolderAccess::updateFolderDate() : SQL : " + sql);
			throw new DataException("Erreur lors de la modification du dossier");
        }
    }
    
    /**
     * Supprime un dossier
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @throws DataException
     */
    public static void deleteFolder(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("FolderAccess::deleteFolder()");
        }
        String sql = "DELETE FROM INT_FOLDER WHERE ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.delete();
        }
        catch(SQLException e) {
            log.error("FolderAccess::deleteFolder() : " + e);
			log.error("FolderAccess::deleteFolder() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du dossier");
        }
    }
    
    /**
     * Construit rcursivement l'arborescence d'un dossier
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @return tree L'arbre
     * @throws DataException
     */
	public static List getFolderTree(Query query, String id) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("FolderAccess::getFolderTree()");
	    }
        
        List res = new ArrayList();
        String sql = "SELECT * FROM INT_FOLDER WHERE PARENT_FOL = " + id;
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            while(result.next()) {
                FolderTree tmp = new FolderTree();
                tmp.setId(result.getString("ID_FOL"));
                tmp.setIntranet(result.getString("ID_INT"));
                tmp.setName(result.getString("NAME_FOL"));
                tmp.setParentid(result.getString("PARENT_FOL"));
                tmp.setDate(result.getString("DATE_FOL"));
				res.add(tmp);
            }
        }
        catch(SQLException e) {
            log.error("FolderAccess::getFolderTree() : " + e);
			log.error("FolderAccess::getFolderTree() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture de l'arborescence");
        }
        Iterator i = res.iterator();
        while(i.hasNext()) {
            FolderTree tmp = (FolderTree)i.next();
            tmp.setSubfolder(getFolderTree(query, tmp.getId()));
        }
	    return res;
    }
    
    /**
     * Teste si un dossier existe dj
     * @param query La connexion  utiliser
     * @param folder Le dossier  tester
     * @return boolean True si le dossier existe, false sinon
     * @throws DataException
     */
    public static boolean folderExist(Query query, Folder folder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("FolderAccess::folderExist()");
        }
        String sql = "SELECT ID_FOL FROM INT_FOLDER WHERE NAME_FOL = '" + RDBMServices.sqlEscape(folder.getName()) + "' AND PARENT_FOL = " + folder.getParentid();
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            return rs.next();
        }
        catch(SQLException e) {
            log.error("FolderAccess::folderExist() : " + e);
		    log.error("FolderAccess::folderExist() : SQL : " + sql);
			throw new DataException("Erreur lors de la v\u00E9rification d'existence");
        }
    }
    
    /**
     * Teste si un dossier est vide
     * @param query La connexion  utiliser
     * @param intranet L'identifiant d'intranet
     * @param id L'identifiant du dossier
     * @return boolean True si le dossier est vide, false sinon
     * @throws DataException
     */
    public static boolean isFolderEmpty(Query query, String intranet, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("FolderAccess::isFolderEmpty(Query, String)()");
        }
        List folders = FolderAccess.getFolders(query, id);
        List docs = DocumentAccess.getDocuments(query, intranet, id);
        return folders.isEmpty() && docs.isEmpty();
    }
    
    /**
     * Retourne le prochain identifiant de dossier
     * @param query La connexion  utiliser
     * @return L'identifiant suivant
     * @throws DataException
     */
    public static String getNextFolder(Query query) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("FolderAccess::getNextFolder()");
        }
        String res = null;
        String sql = "SELECT VALUE_KEY FROM INT_KEY WHERE NAME_KEY = 'INT_FOLDER'";
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            rs.next();
            res = rs.getString("VALUE_KEY");
            sql = "UPDATE INT_KEY SET VALUE_KEY = VALUE_KEY + 1 WHERE NAME_KEY = 'INT_FOLDER'";
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("FolderAccess::getNextFolder() : " + e);
		    log.error("FolderAccess::getNextFolder() : SQL : " + sql);
			throw new DataException("Erreur lors de la g\u00E9n\u00E9ration d'identifiant");
        }
        return res;
    }
}
