package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.MIME;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.RDBMServices;

/**
 * MIMEAccess<br>
 * <br>
 * Ralise les oprations relatives aux types MIME dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class MIMEAccess {
    
    protected static Log log = LogFactory.getLog(MIMEAccess.class);
    
    /**
	 * Rcupre tous les types MIME
	 * @param query La connexion  utiliser
	 * @return mimes La liste des types MIME
	 * @throws DataException
	 */
	public static List getMIMEs(Query query) throws DataException {
	    if(log.isDebugEnabled()) {
	        log.debug("MIMEAccess::getMIMEs()");
	    }
	    List mimes = new ArrayList();
	    String sql = "SELECT * FROM INT_MIME";
	    try {
	        query.setSql(sql);
	        query.select();
	        ResultSet rs = query.getRs();
	        while(rs.next()) {
	            MIME tmp = new MIME();
	            tmp.setId(rs.getString("EXT_MIME"));
	            tmp.setName(rs.getString("TYPE_MIME"));
	            mimes.add(tmp);
	        }
	    }
	    catch(SQLException e) {
	        log.error("MIMEAccess::getMIMEs() : " + e);
		    log.error("MIMEAccess::getMIMEs() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des types MIME");
	    }
	    return mimes;
	}
	
	/**
	 * Cre un type MIME
	 * @param query La connexion  utiliser
	 * @param mime Le type MIME  crer
	 */
	public static void createMIME(Query query, MIME mime) throws DataException {
	    if(log.isDebugEnabled()) {
	        log.debug("MIMEAccess::createMIME()");
	    }
	    StringBuffer sql = new StringBuffer();
	    sql.append("INSERT INTO INT_MIME(EXT_MIME, TYPE_MIME) VALUES(");
	    sql.append("'" + mime.getId() + "', ");
	    sql.append("'" + RDBMServices.sqlEscape(mime.getName()) + "')");
	    try {
	        query.setSql(sql.toString());
	        query.insert();
	    }
	    catch(SQLException e) {
	        log.error("MIMEAccess::createMIME() : " + e);
		    log.error("MIMEAccess::createMIME() : SQL : " + sql);
			throw new DataException("Erreur lors de la cr\u00E9ation du type MIME");
	    }
	}
	
	/**
	 * Supprime un type MIME
	 * @param query La connexion  utiliser
	 * @param extension L'extension associe au type MIME
	 * @throws DataException
	 */
	public static void removeMIME(Query query, String extension) throws DataException {
	    if(log.isDebugEnabled()) {
	        log.debug("MIMEAccess::removeMIME()");
	    }
	    String sql = "DELETE FROM INT_MIME WHERE EXT_MIME = '" + extension + "'";
	    try {
	        query.setSql(sql);
	        query.delete();
	    } 
	    catch(SQLException e) {
	        log.error("MIMEAccess::removeMIME() : " + e);
		    log.error("MIMEAccess::removeMIME() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du type MIME");
	    }
	}
	
	/**
	 * Teste si un type MIME existe dj
	 * @param query La connexion  utiliser
	 * @param extension L'extension du type  tester
	 * @return boolean True si le type MIME existe, false sinon
	 * @throws DataException
	 */
	public static boolean mimeExist(Query query, String extension) throws DataException {
	    if(log.isDebugEnabled()) {
	        log.debug("MIMEAccess::mimeExist()");
	    }
	    String sql = "SELECT EXT_MIME FROM INT_MIME WHERE EXT_MIME = '" + extension + "'";
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            return rs.next();
        }
        catch(SQLException e) {
            log.error("MIMEAccess::mimeExist() : " + e);
		    log.error("MIMEAccess::mimeExist() : SQL : " + sql);
			throw new DataException("Erreur lors de la v\u00E9rification d'existence");
        }
	}
}
