package org.esupportail.portal.channels.CIntranet.filters;

import java.util.Iterator;
import java.util.List;

import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.channels.CIntranet.utils.Date;

/**
 * Filter<br>
 * <br>
 * Point d'entre aux fonctions de filtrage<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class Filter {

    /**
     * Filtrage des documents affichables en fonction du niveau de l'utilisateur
     * @param documents Liste des documents  filtrer
     * @param user L'identifiant de l'utilisateur
     * @param level Niveau de l'utilisateur
     * @return documents Liste filtre
     */
    public static void documentFilter(List documents, String user, int level) {
        switch(level) {
        	case Security.ED_FULL:
        	case Security.ED_VAL: {
        	    modifiedDocumentFilter(documents);
        	    break;
        	}
        	case Security.AUT_FULL:
        	case Security.AUT_MOD:
        	case Security.AUT_NEW:
        	case Security.NONE: {
        	    modifiedDocumentFilter(documents);
        	    invalidDocumentFilter(documents, user);
        	    invisibleDocumentFilter(documents);
        	    perimedDocumentFilter(documents);
        	    break;
        	}
        	default : {
        	    documents.clear();
        	}
        }
    }
    
    /**
     * Filtrage des documents masqus
     * @param documents La liste des documents  filtrer
     */
    private static void invisibleDocumentFilter(List documents) {
        for(Iterator i = documents.iterator();i.hasNext();) {
            Document tmp = (Document)i.next();
            if(!tmp.isVisible()) {
                i.remove();
            }
        }
    }
    
    /**
     * Filtrage des documents prims
     * @param documents La liste des documents  filtrer
     */
    private static void perimedDocumentFilter(List documents) {
        for(Iterator i = documents.iterator();i.hasNext();) {
            Document tmp = (Document)i.next();
            if(!tmp.getValidityDate().equals("99999999")) {
                if(Date.getCurrentDate().compareTo(tmp.getValidityDate()) > 0) {
                    i.remove();
                }
            }
        }
    }
    
    /**
     * Filtrage des documents en cours de modifications
     * @param documents La liste des documents  filtrer
     */
    private static void modifiedDocumentFilter(List documents) {
        for(Iterator i = documents.iterator();i.hasNext();) {
            Document tmp = (Document)i.next();
            if(tmp.isPendingModification() && !tmp.isValid()) {
                i.remove();
            }
        }
    }
    
    /**
     * Filtrage des documents invalides
     * @param documents La liste des documents  filtrer
     */
    private static void invalidDocumentFilter(List documents, String user) {
        for(Iterator i = documents.iterator();i.hasNext();) {
            Document tmp = (Document)i.next();
            if(!tmp.isValid() && !tmp.getAuthor().equals(user)) {
                i.remove();
            }
        }
    }

    /**
     * Filtrage des documents visibles par les diteurs
     * @param documents La liste des documents  filtrer
     * @param user L'identifiant de l'utilisateur
     * @throws SecurityException
     */
    public static void searchEditorFilter(List documents, String user) throws SecurityException {
        for(Iterator i = documents.iterator();i.hasNext();) {
            Document tmp = (Document)i.next();
            if(!Security.isAdmin(user) && Security.getLevel(user, tmp.getFolderid()) < Security.ED_VAL) {
                i.remove();
            }
            else {
                if(tmp.isPendingModification() && !tmp.isValid()) {
                    i.remove();
                }
            }
        }
    }
}
