package org.esupportail.portal.channels.CIntranet.security;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Entity;
import org.esupportail.portal.channels.CIntranet.beans.Grant;
import org.esupportail.portal.channels.CIntranet.beans.Group;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.utils.Groups;
import org.jasig.portal.groups.GroupsException;

/**
 * Security<br>
 * <br>
 * Classe prenant en charge la gestion de la scurit<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class Security {
    
    protected static Log log = LogFactory.getLog(Security.class);
    
    public static final int NONE = 0;
    public static final int AUT_NEW = 10;
    public static final int AUT_MOD = 20;
    public static final int AUT_FULL = 30;
    public static final int ED_VAL = 40;
    public static final int ED_FULL = 50;
    
    /**
     * Appartenance aux administrateurs
     * @param id l'identifiant de l'utilisateur
     * @return admin true | false
     * @throws SecurityException
     */
    public static boolean isAdmin(String id) throws SecurityException {
        if(log.isDebugEnabled()) {
            log.debug("Security::isSuperUser()");
        }
        List admins = null;
        DataControler data = new DataControler();
        try {
            admins = data.getAdmins();
        }
        catch(DataException e) {
            log.error("Security::isAdmin() : DataException :\n" + e);
            throw new SecurityException(e.getMessage());
        }
        for(Iterator i = admins.iterator();i.hasNext();) {
            String user = ((Entity)i.next()).getId();
            if(id.equals(user)) {
                return true;
            }
        }
        return false;
    }
    
    /**
     * Accs  un intranet
     * @param id l'identifiant de l'utilisateur
     * @param intranetid l'identifiant de l'intranet
     * @return access true | false
     * @throws SecurityException
     */
    public static boolean isIntranetAccessible(String id, String intranetid) throws SecurityException {
        if(log.isDebugEnabled()) {
            log.debug("Security::isIntranetAccessible()");
        }
        List entities = null;
        DataControler data = new DataControler();
        try {
            entities = data.getIntranetEntities(intranetid);
        }
        catch(DataException e) {
            log.error("Security::isIntranetAccessible() : DataException :\n" + e);
            throw new SecurityException(e.getMessage());
        }
        for(Iterator i = entities.iterator();i.hasNext();) {
            Entity en = (Entity)i.next();
            if(en instanceof User && id.equals(en.getId())) {
                return true;
            }
            try {
                if(en instanceof Group && Groups.isMemberOf(id, en.getId())) {
                    return true;
                }
            }
            catch(GroupsException e) {
                log.error("Security::isIntranetAccessible() : GroupsException :\n" + e);
                throw new SecurityException("Erreur lors de la recherche d'accessibilit\u00E9 pour cet intranet");
            }
        }
        return false;
    }
    
    /**
     * Retourne le niveau de droit pour un dossier
     * @param id l'identifiant de l'utilisateur
     * @param folderid l'identifiant du dossier
     * @return level NONE | AUT_NEW | AUT_MOD | AUT_MOD | VAL_FOL | ED_VAL | ED_ADM
     * @throws SecurityException
     */
    public static int getLevel(String id, String folderid) throws SecurityException {
        if(log.isDebugEnabled()) {
            log.debug("Security::getLevel()");
        }
        List grants = null;
        DataControler data = new DataControler();
        try {
            grants = data.getGrants(folderid);
        }
        catch(DataException e) {
            log.error("Security::getLevel() : DataException :\n" + e);
            throw new SecurityException(e.getMessage());
        }
        Collections.sort(grants);
        Collections.reverse(grants);
        for(Iterator i = grants.iterator();i.hasNext();) {
            Grant tmp = (Grant)i.next();
            Entity ent = tmp.getGranted();
            if(ent instanceof User && id.equals(ent.getId())) {
                return tmp.getLevel();
            }
            if(tmp.getGranted() instanceof Group) {
                Group g = (Group)tmp.getGranted();
                try {
                    if(g.getId().equals("_EVERYBODY")) {
                        return tmp.getLevel();
                    }
                    if(Groups.isMemberOf(id, g.getId())) {
                        return tmp.getLevel();
                    }
                }
                catch(GroupsException e) {
                    log.error("Security::isIntranetAccessible() : GroupsException :\n" + e);
                    throw new SecurityException("Erreur lors de la recherche de droit pour ce dossier");
                }
            }
        }
        return NONE;
    }
}
