package org.esupportail.portal.channels.CIntranet.storage;

import java.io.InputStream;
import java.util.Map;

import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;

/**
 * IStorageControler<br>
 * <br>
 * Interface dcrivant les mthodes que doit obligatoirement implmenter<br>
 * un contrleur de ressource de stockage physique<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */

public interface IStorageControler {
	
	/**
	 * Sauvegarde d'un document
	 * @param intranet l'identifiant de l'intranet
	 * @param doc le document
	 * @param in le flux de lecture vers le contenu du document
	 * @throws StorageException
	 */
	public void saveDocument(String intranet, Document doc, InputStream in) throws StorageException;
	
	/**
	 * Lecture d'un document
	 * @param intranet l'identifiant de l'intranet
	 * @param doc le document
	 * @return le flux de lecture vers le document stock
	 * @throws StorageException
	 */
	public InputStream loadDocument(String intranet, Document doc) throws StorageException;
	
	/**
	 * Mise  jour d'un document
	 * @param intranet l'identifiant de l'intranet
	 * @param doc le document
	 * @param in le flux de lecture vers le nouveau contenu, null si pas de mise  jour du contenu
	 * @throws StorageException
	 */
	public void updateDocument(String intranet, Document doc, InputStream in) throws StorageException;
	
	/**
	 * Suppression d'un document
	 * @param intranet l'identifiant de l'intranet
	 * @param doc le document
	 * @throws StorageException
	 */
	public void destroyDocument(String intranet, Document doc) throws StorageException;
	
	/**
	 * Cration d'un intranet
	 * @param intranet l'intranet  crer
	 * @throws StorageException
	 */
	public void createIntranet(Intranet intranet) throws StorageException;
	
	/**
	 * Suppression d'un intranet et de tous ses documents
	 * @param intranet l'identifiant de l'intranet
	 * @throws StorageException
	 */
	public void destroyIntranet(String intranet) throws StorageException;
	
	/**
	 * Liste des paramtres spcifiques  l'implmentation du IStorageControler
	 * @param parameters les paramtres
	 */
	public void setParameters(Map parameters);
}
