package org.esupportail.portal.channels.CIntranet.utils;

import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerServantFactory;
import org.jasig.portal.services.GroupService;
import org.xml.sax.ContentHandler;

/**
 * GroupsManagerAdapter<br>
 * <br>
 * Adaptateur permettant de faire appel au GroupsManager depuis le MAG<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class GroupsManagerAdapter implements IServant {
    
    private IServant slave = null;
    private ChannelStaticData staticData = null;
    
    /**
     * Constructeur
     */
    public GroupsManagerAdapter() {
    }

    /**
     * Indique au canal matre si le servant a fini
     * Implements IServant interface
     * @return finished true | false
     */
    public boolean isFinished() {
        if(slave.isFinished()) {
            staticData.setParameter("groupManagerFinished", "false");
            return true;
        }
        return false;
    }

    /**
     * Retourne les rsultats du servant
     * Implements IServant interface
     * @return results Un tableau d'objets
     */
    public Object[] getResults() {
        return slave.getResults();
    }

    /**
     * Callback GroupsManager
     * Implements IChannel interface
     * @param sd ChannelStaticData
     */
    public void setStaticData(ChannelStaticData sd) throws PortalException {
        staticData = sd;
        slave = CGroupsManagerServantFactory.getGroupsServantforSelection(staticData, "S\u00E9lectionnez un groupe", GroupService.EVERYONE, true, true);
    }

    /**
     * Callback GroupsManager
     * Implements IChannel interface
     * @param rd ChannelRuntimeData
     */
    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        slave.setRuntimeData(rd);
    }

    /**
     * Callback GroupsManager
     * Implements IChannel interface
     * @param ev PortalEvent
     */
    public void receiveEvent(PortalEvent ev) {
        slave.receiveEvent(ev);
    }

    /**
     * Callback GroupsManager
     * Implements IChannel interface
     * @return rp ChannelRuntimeProperties
     */
    public ChannelRuntimeProperties getRuntimeProperties() {
        return slave.getRuntimeProperties();
    }

    /**
     * Callback GroupsManager
     * Implements IChannel interface
     * @param out ContentHandler
     */
    public void renderXML(ContentHandler out) throws PortalException {
        slave.renderXML(out);
    }
}
