package org.esupportail.portal.channels.CIntranet.utils;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Entity;
import org.esupportail.portal.channels.CIntranet.beans.Group;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.utils.Groups;
import org.esupportail.portal.utils.Users;
import org.jasig.portal.groups.GroupsException;

/**
 * UsersGroupsNames<br>
 * <br>
 * Description<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class UsersGroupsNames {
    
    protected static Log log = LogFactory.getLog(UsersGroupsNames.class);
    
    /**
     * Rcupre le noms d'une d'entit
     * @param entity L'entit
     */
    public static void getName(Entity entity) {
        if(entity instanceof User) {
            User u = (User)entity;
            u.setName(Users.getUserDisplayName(u.getId()));
        }
        if(entity instanceof Group) {
            Group g = (Group)entity;
            if(g.getId().equals("_EVERYBODY")) {
                g.setName("Tous les membres de cet intranet");
            }
            else {
                try {
                    g.setName(Groups.getGroupName(g.getId()));
                }
                catch(GroupsException e) {
                    log.error("UsersGroupsNames::getName() : GroupsException :\n" + e);
                    g.setName("Groupe inconnu");
                }
            }
        }
    }
    
    /**
     * Rcupre les noms d'une liste d'entits
     * @param entities La liste d'entits
     */
    public static void getNames(List entities) {
        for(Iterator i = entities.iterator();i.hasNext();) {
            Entity en = (Entity)i.next();
            if(en instanceof User) {
                User u = (User)en;
                u.setName(Users.getUserDisplayName(u.getId()));
            }
            if(en instanceof Group) {
                Group g = (Group)en;
                if(g.getId().equals("_EVERYBODY")) {
                    g.setName("Tous les membres de cet intranet");
                }
                else {
                    try {
                        g.setName(Groups.getGroupName(g.getId()));
                    }
                    catch(GroupsException e) {
                        log.error("UsersGroupsNames::getNames() : GroupsException :\n" + e);
                        g.setName("Groupe inconnu");
                    }
                }
            }
        }
    }
}
