<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="folder" />
<xsl:param name="action" />
<xsl:param name="servant"/>

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>

	<table border="0" width="100%" cellspacing="0" cellpadding="5">
		<tr>
			<td class="uportal-channel-table-header" nowrap="true">Ajout d'un groupe</td>
			<td>
				<a href="{$baseActionURL}?action=permissions&amp;folder={$folder}">
					<img src="{$mediaPath}26x26ab/back.gif" alt="Retour" title="Retour" border="0" />
				</a>
			</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	
	<a href="{$baseActionURL}?action={$servant}&amp;folder={$folder}">Ajouter un utilisateur</a>
	
	<br/>
	
	<form method="post" action="{$baseActionURL}">
	<input type="hidden" name="action" value="{$action}" />
	<table border="0" cellspacing="0" cellpadding="2">
		<xsl:apply-templates select="group" />
	</table>
	<input class="uportal-button" type="submit" value="Ajouter" />
	</form>

</xsl:template>

<xsl:template match="group">
	<tr>
		<td>
			<input type="checkbox" name="selected" value="{./@id}" />
		</td>
		<td valign="absmiddle">
			<img src="{$mediaPath}20x20sb/group.gif" border="0" />
		</td>
		<td class="uportal-text"><xsl:value-of select="./@name" /></td>
	</tr>
</xsl:template>

</xsl:stylesheet>