<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />

<xsl:template match="xml">
	
	<table border="0" width="100%" cellspacing="0" cellpadding="5">
	<tr>
		<td class="uportal-channel-table-header" nowrap="true">Liste des Intranets</td>
		<td width="100%">&#160;</td>
	</tr>
	</table>
	<hr/>
	<br/>
	<xsl:apply-templates select="intranets" />
	
</xsl:template>

<xsl:template match="intranets">
	<table border="0" width="100%" cellspacing="0" cellpadding="5">
	
	<xsl:choose>
		<xsl:when test="count(intranet)=0">
			<tr>
				<td class="uportal-channel-error">Aucun intranet accessible</td>
			</tr>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="intranet" />
		</xsl:otherwise>
	</xsl:choose>
	
	</table>
</xsl:template>

<xsl:template match="intranet">
	<tr>
		<td class="uportal-label">
			<a href="{$baseActionURL}?action=viewfolder&amp;folder={./@folderid}&amp;intranet={./@id}">
				<xsl:value-of select="./@name" />
			</a>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>