<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="folder" />
<xsl:param name="user" />

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>

	<table border="0" width="100%" cellspacing="0" cellpadding="5">
		<tr>
			<td class="uportal-channel-table-header" nowrap="true">Permissions</td>
			<td>
				<a href="{$baseActionURL}?action=viewfolder&amp;folder={$folder}">
					<img src="{$mediaPath}26x26ab/back.gif" alt="Retour" title="Retour" border="0" />
				</a>
			</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	
	<xsl:apply-templates select="ed_full" />
	<br/>
	<br/>
	<xsl:apply-templates select="ed_val" />
	<br/>
	<br/>
	<xsl:apply-templates select="aut_full" />
	<br/>
	<br/>
	<xsl:apply-templates select="aut_mod" />
	<br/>
	<br/>
	<xsl:apply-templates select="aut_new" />

</xsl:template>

<xsl:template match="ed_full">
	
	<table width="100%" cellpadding="5" cellspacing="0" border="0">
		<tr class="uportal-background-med">
		    <td class="uportal-channel-table-caption" nowrap="true">5 - Contrle total - Gestion des permissions</td>
			<td>&#160;</td>
			<td><a href="{$baseActionURL}?action=add_ed_full&amp;folder={$folder}">Ajouter</a></td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	
	<table width="100%" border="0" cellspacing="0" cellpadding="1">
		
		<xsl:call-template name="grant.notify" />
		
	</table>
	
</xsl:template>

<xsl:template match="ed_val">
	
	<table width="100%" cellpadding="5" cellspacing="0" border="0">
		<tr class="uportal-background-med">
		    <td class="uportal-channel-table-caption" nowrap="true">4 - Contrle total - Validation</td>
			<td>&#160;</td>
			<td><a href="{$baseActionURL}?action=add_ed_val&amp;folder={$folder}">Ajouter</a></td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	
	<table width="100%" border="0" cellspacing="0" cellpadding="1">
		
		<xsl:call-template name="grant.notify" />
		
	</table>
	
</xsl:template>

<xsl:template match="aut_full">
	
	<table width="100%" cellpadding="5" cellspacing="0" border="0">
		<tr class="uportal-background-med">
		    <td class="uportal-channel-table-caption" nowrap="true">3 - Toutes oprations - Non soumises  validation</td>
			<td>&#160;</td>
			<td><a href="{$baseActionURL}?action=add_aut_full&amp;folder={$folder}">Ajouter</a></td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	
	<table width="100%" border="0" cellspacing="0" cellpadding="1">
		
		<xsl:call-template name="grant.normal" />
		
	</table>
	
</xsl:template>

<xsl:template match="aut_mod">
	
	<table width="100%" cellpadding="5" cellspacing="0" border="0">
		<tr class="uportal-background-med">
		    <td class="uportal-channel-table-caption" nowrap="true">2 - Toutes oprations - Soumises  validation</td>
			<td>&#160;</td>
			<td><a href="{$baseActionURL}?action=add_aut_mod&amp;folder={$folder}">Ajouter</a></td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	
	<table width="100%" border="0" cellspacing="0" cellpadding="1">
		
		<xsl:call-template name="grant.normal" />
		
	</table>
	
</xsl:template>

<xsl:template match="aut_new">
	
	<table width="100%" cellpadding="5" cellspacing="0" border="0">
		<tr class="uportal-background-med">
		    <td class="uportal-channel-table-caption" nowrap="true">1 - Dpt de documents - Soumis  validation</td>
			<td>&#160;</td>
			<td><a href="{$baseActionURL}?action=add_aut_new&amp;folder={$folder}">Ajouter</a></td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	
	<table width="100%" border="0" cellspacing="0" cellpadding="1">
		
		<xsl:call-template name="grant.normal" />
		
	</table>
	
</xsl:template>

<xsl:template name="grant.notify">
	
	<xsl:for-each select="grant">
		<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
			<xsl:choose>
				<xsl:when test="./@extended='true'">
					<xsl:call-template name="user.extended" />
				</xsl:when>
				<xsl:when test="./@extended='false'">
					<xsl:call-template name="user.normal" />
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="./user/@id=$user">
					<xsl:choose>
						<xsl:when test="./@notification='true'">
							<td>
								<a href="{$baseActionURL}?action=notification&amp;folder={$folder}&amp;level={./@level}&amp;notif=no">
									<img src="{$mediaPath}20x20sb/invalid.gif" border="0" alt="Ne plus tre notifi" title="Ne plus tre notifi"/>
								</a>
							</td>
						</xsl:when>
						<xsl:when test="./@notification='false'">
							<td>
								<a href="{$baseActionURL}?action=notification&amp;folder={$folder}&amp;level={./@level}&amp;notif=yes">
									<img src="{$mediaPath}20x20sb/validnot.gif" border="0" alt="Etre notifi" title="Etre notifi"/>
								</a>
							</td>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<td><img src="{$mediaPath}20x20sbg/valid.gif" border="0" /></td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	</xsl:for-each>
	
</xsl:template>

<xsl:template name="grant.normal">
	
	<xsl:for-each select="grant">
		<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
			<xsl:choose>
				<xsl:when test="./@extended='true'">
					<xsl:choose>
						<xsl:when test="./@type='user'">
							<xsl:call-template name="user.extended" />
						</xsl:when>
						<xsl:when test="./@type='group'">
							<xsl:call-template name="group.extended" />
						</xsl:when>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="./@extended='false'">
					<xsl:choose>
						<xsl:when test="./@type='user'">
							<xsl:call-template name="user.normal" />
						</xsl:when>
						<xsl:when test="./@type='group'">
							<xsl:call-template name="group.normal" />
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</tr>
	</xsl:for-each>
	
</xsl:template>

<xsl:template name="user.extended">
	
	<td><img src="{$mediaPath}20x20sbg/user.gif" border="0" /></td>
    <td class="uportal-text" width="100%"><xsl:value-of select="./user/@name" /></td>
    <td><img src="{$mediaPath}20x20sbg/del.gif" border="0" /></td>
	
</xsl:template>

<xsl:template name="user.normal">
	
	<td><img src="{$mediaPath}20x20sb/user.gif" border="0" /></td>
    <td class="uportal-text" width="100%"><xsl:value-of select="./user/@name" /></td>
    <td>
		<a href="{$baseActionURL}?action=delgrant&amp;folder={$folder}&amp;type=user&amp;id={./user/@id}&amp;level={./@level}">
			<img src="{$mediaPath}20x20sb/del.gif" border="0" />
		</a>
	</td>
	
</xsl:template>

<xsl:template name="group.extended">
	
	<td><img src="{$mediaPath}20x20sbg/group.gif" border="0" /></td>
    <td class="uportal-text" width="100%"><xsl:value-of select="./group/@name" /></td>
    <td><img src="{$mediaPath}20x20sbg/modify.gif" border="0" /></td>
    <td><img src="{$mediaPath}20x20sbg/del.gif" border="0" /></td>
	
</xsl:template>

<xsl:template name="group.normal">
	
	<td><img src="{$mediaPath}20x20sb/group.gif" border="0" /></td>
    <td class="uportal-text" width="100%"><xsl:value-of select="./group/@name" /></td>
    <td>
		<a href="{$baseActionURL}?action=delgrant&amp;folder={$folder}&amp;type=group&amp;id={./group/@id}&amp;level={./@level}">
			<img src="{$mediaPath}20x20sb/del.gif" border="0" />
		</a>
	</td>
	
</xsl:template>

</xsl:stylesheet>