<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="baseDownloadURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="intranet"/>
<xsl:param name="folder" />
<xsl:param name="fname" />
<xsl:param name="server_cas" />
<xsl:param name="server_esup" />

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>

	<table border="0" width="100%" cellspacing="0" cellpadding="5">
		<tr>
			<td class="uportal-channel-table-header" nowrap="true">Dtails d'un document</td>
			<td>
				<a href="{$baseActionURL}?action=viewfolder&amp;folder={$folder}">
					<img src="{$mediaPath}26x26ab/back.gif" alt="Retour" title="Retour" border="0" />
				</a>
			</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	
	<xsl:apply-templates select="document" />

</xsl:template>


<xsl:template match="document">

	<xsl:choose>
		
		<xsl:when test="./@type='file'">
			<xsl:call-template name="document.file" />
		</xsl:when>
		
		<xsl:when test="./@type='link'">
			<xsl:call-template name="document.link" />
		</xsl:when>
		
	</xsl:choose>
	
</xsl:template>


<xsl:template name="document.file">
	
	<table border="0" cellpadding="2" cellspacing="0">
		<tr>
			<td class="uportal-label" nowrap="true">Nom : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true">
				<a href="{$baseDownloadURL}?action=download&amp;folder={$folder}&amp;id={./@id}">
					<xsl:value-of select="./@file" />
				</a>
			</td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Libell : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@description" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Auteur : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@author" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Date : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Date de premption : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@validitytext" /></td>
		</tr>
		<xsl:call-template name="document.state" />
		<xsl:call-template name="document.url" />
	</table>
	
</xsl:template>

<xsl:template name="document.link">
	
	<table border="0" cellpadding="2" cellspacing="0">
		<tr>
			<td class="uportal-label" nowrap="true">URL : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true">
				<a href="{./@url}" target="_blank">
					<xsl:value-of select="./@url" />
				</a>
			</td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Libell : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@description" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Auteur : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@author" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Date : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		</tr>
		<tr>
			<td class="uportal-label" nowrap="true">Date de premption : </td>
			<td>&#160;</td>
			<td class="uportal-text" nowrap="true"><xsl:value-of select="./@validitytext" /></td>
		</tr>
		<xsl:call-template name="document.state" />
		<xsl:call-template name="document.url" />
	</table>
	
</xsl:template>

<xsl:template name="document.state">
	<tr>
		<td class="uportal-label" nowrap="true">Etat : </td>
		<td>&#160;</td>
		
		<xsl:choose>
			<xsl:when test="./@modified='true'">
				<td class="uportal-text" nowrap="true">Modifications en attente de validation</td>				
			</xsl:when>
			<xsl:when test="./@deleted='true'">
				<td class="uportal-text" nowrap="true">Suppression en attente de validation</td>				
			</xsl:when>
			<xsl:when test="./@valid='false'">
				<td class="uportal-text" nowrap="true">Dpt en attente de validation</td>				
			</xsl:when>
			<xsl:when test="./@visible='false'">
				<td class="uportal-text" nowrap="true">Masqu</td>				
			</xsl:when>
			<xsl:when test="./@perimed='true'">
				<td class="uportal-text" nowrap="true">Prim</td>				
			</xsl:when>
			<xsl:otherwise>
				<td class="uportal-text" nowrap="true">Valide</td>				
			</xsl:otherwise>
		</xsl:choose>
	</tr>
</xsl:template>

<xsl:template name="document.url">
	<tr>
		<td class="uportal-label" nowrap="true">Raccourci :</td>
		<td>&#160;</td>
		<td class="uportal-text" nowrap="true">
			<a href="{$server_cas}?service={$server_esup}?uP_fname={$fname}%26uP_args%3Daction=viewdocument%7Cintranet%3D{$intranet}%7Cfolder%3D{$folder}%7Cid%3D{./@id}" target="none">
				Copiez ce lien pour donner un accs direct  ce document
			</a>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>