package org.esupportail.portal.channels.CIntranet.beans;

import org.jasig.portal.utils.XMLEscaper;

/**
 * Intranet<br>
 * <br>
 * Classe dfinissant le comportement d'un intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.3 $
 * 
 */
public class Intranet implements Comparable, XMLSerializable {

    private String id = "";
    private String name = "";
    private int order = 0;
    private String folder = "";
    private String ressource = "";
    
    /**
     * Constructeur
     */
    public Intranet() {
    }
    
    /**
     * Retourne l'identifiant
     * @return id L'identifiant
     */
    public String getId() {
        return id;
    }
    
    /**
     * Positionne l'identifiant
     * @param id L'identifiant
     */
    public void setId(String id) {
        this.id = id;
    }
    
    /**
     * Retourne le nom
     * @return name Le nom
     */
    public String getName() {
        return name;
    }
    
    /**
     * Positionne le nom
     * @param name Le nom
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * Retourne l'ordre
     * @return order L'ordre
     */
    public int getOrder() {
        return order;
    }
    
    /**
     * Positionne l'ordre 
     * @param order L'ordre
     */
    public void setOrder(int order) {
        this.order = order;
    }
    
    /**
     * Retourne le dossier racine
     * @return folder Le dossier racine
     */
    public String getFolder() {
        return folder;
    }
    
    /**
     * Positionne le dossier racine
     * @param folder Le dossier racine
     */
    public void setFolder(String folder) {
        this.folder = folder;
    }
    
    /**
     * Retourne la ressource
     * @return ressource La ressource
     */
    public String getRessource() {
        return ressource;
    }
    
    /**
     * Positionne la ressource
     * @param ressource La ressource
     */
    public void setRessource(String ressource) {
        this.ressource = ressource;
    }
    
    /**
     * Compare deux intranets suivant leur nom
     * Implements Comparable interface
     * @param o Objet  comparer
     */
    public int compareTo(Object o) {
        if(!(o instanceof Intranet)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        Intranet i = (Intranet)o;
        return getOrder() - i.getOrder();
    }

    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<intranet id=\"");
        xml.append(getId());
        xml.append("\" name=\"");
        xml.append(XMLEscaper.escape(getName()));
        xml.append("\" order=\"");
        xml.append(getOrder());
        xml.append("\" folderid=\"");
        xml.append(getFolder());
        xml.append("\" ressource=\"");
        xml.append(XMLEscaper.escape(getRessource()));
        xml.append("\" />\n");
        return xml.toString();
    }
}
