<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:import href="./ViewFolder_templates.xsl" />

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="baseDownloadURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="level" />

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>
	
	<table width="100%" border="0" cellspacing="0" cellpadding="5">
		<tr>
			<xsl:call-template name="outil.nouveau.document" />
			<xsl:call-template name="outil.nouveau.dossier" />
			<xsl:call-template name="outil.recherche" />
			<xsl:call-template name="outil.arbre" />
			<xsl:if test="$level > 30">
				<xsl:call-template name="outil.vue.admin" />
			</xsl:if>
			<xsl:call-template name="outil.intranets" />
			
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	
	<!--<xsl:call-template name="construction"/>
	<br/>-->
	
	<table border="0" width="100%">
		<tr>
			<xsl:apply-templates select="path/folder" />
			<td width="100%">&#160;</td>
		</tr>
	</table>

	<table border="0" cellpadding="1" cellspacing="0">
		<xsl:apply-templates select="folders/folder" />
	</table>
	<br/>
	<br/>
	<xsl:apply-templates select="documents" />

</xsl:template>

<xsl:template match="folders/folder">
	<xsl:call-template name="dossier.modification" />
</xsl:template>

<xsl:template match="documents">
	<xsl:choose>
		<xsl:when test="count(document)!=0">
				<table border="0" cellpadding="1" cellspacing="0">
					<tr class="uportal-background-med">
						<td>&#160;</td>
						<td>&#160;</td>
						<td class="uportal-channel-strong" align="center">
							<a href="{$baseActionURL}?action=order&amp;folder={/xml/folder/@id}&amp;order=order">Ordre</a>
						</td>
						<td width="20">&#160;</td>
						<td>&#160;</td>
						<td class="uportal-channel-strong" align="center">
							<a href="{$baseActionURL}?action=order&amp;folder={/xml/folder/@id}&amp;order=date">Libell</a>
						</td>
						<td width="10">&#160;</td>
						<td class="uportal-channel-strong" align="center">Etat</td>
						<td width="10">&#160;</td>
						<td class="uportal-channel-strong" align="center">
							<a href="{$baseActionURL}?action=order&amp;folder={/xml/folder/@id}&amp;order=author">Auteur</a>
						</td>
						<td width="10">&#160;</td>
						<td class="uportal-channel-strong" align="center">
							<a href="{$baseActionURL}?action=order&amp;folder={/xml/folder/@id}&amp;order=date">Date</a>
						</td>
						<td width="100%">&#160;</td>
					</tr>
					<xsl:apply-templates select="document" />
				</table>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="document">
	<xsl:choose>
		<xsl:when test="./@type='file'">
			<xsl:call-template name="document.file" />
		</xsl:when>
		<xsl:when test="./@type='link'">
			<xsl:call-template name="document.link" />
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name="document.file">
	<xsl:choose>
		<xsl:when test="./@modified='true'">
			<xsl:call-template name="document.file.modified" />
		</xsl:when>
		<xsl:when test="./@deleted='true'">
			<xsl:call-template name="document.file.deleted" />
		</xsl:when>
		<xsl:when test="./@valid='false'">
			<xsl:call-template name="document.file.invalid"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="document.file.valid" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="document.link">
	<xsl:choose>
		<xsl:when test="./@modified='true'">
			<xsl:call-template name="document.link.modified" />
		</xsl:when>
		<xsl:when test="./@deleted='true'">
			<xsl:call-template name="document.link.deleted" />
		</xsl:when>
		<xsl:when test="./@valid='false'">
			<xsl:call-template name="document.link.invalid"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="document.link.valid" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="document.file.modified">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<xsl:call-template name="document.outil.zoom" />
		<xsl:call-template name="document.outil.modify.alert" />
		<xsl:call-template name="document.outil.delete.off" />
		<td width="20">&#160;</td>
		<xsl:call-template name="document.icon"/>
		<td class="uportal-channel-strong" nowrap="true">
			<a href="{$baseDownloadURL}?action=download&amp;folder={./@folder}&amp;id={./@id}">
				<xsl:value-of select="./@description" />
			</a>
		</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true">Modifi</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@author" /></td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template name="document.file.deleted">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<xsl:call-template name="document.outil.zoom" />
		<xsl:call-template name="document.outil.modify.off" />
		<xsl:call-template name="document.outil.delete.alert" />
		<td width="20">&#160;</td>
		<xsl:call-template name="document.icon"/>
		<td class="uportal-channel-strong" nowrap="true">
			<a href="{$baseDownloadURL}?action=download&amp;folder={./@folder}&amp;id={./@id}">
				<xsl:value-of select="./@description" />
			</a>
		</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true">Supprim</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@author" /></td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template name="document.file.invalid">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<xsl:call-template name="document.outil.zoom" />
		<xsl:call-template name="document.outil.modify.off" />
		<xsl:call-template name="document.outil.delete" />
		<td width="20">&#160;</td>
		<xsl:call-template name="document.icon"/>
		<td class="uportal-channel-strong" nowrap="true">
			<a href="{$baseDownloadURL}?action=download&amp;folder={./@folder}&amp;id={./@id}">
				<xsl:value-of select="./@description" />
			</a>
		</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true">Nouveau</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@author" /></td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template name="document.file.valid">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<xsl:call-template name="document.outil.zoom" />
		<xsl:call-template name="document.outil.modify" />
		<xsl:call-template name="document.outil.delete" />
		<td width="20">&#160;</td>
		<xsl:call-template name="document.icon"/>
		<td class="uportal-channel-strong" nowrap="true">
			<a href="{$baseDownloadURL}?action=download&amp;folder={./@folder}&amp;id={./@id}">
				<xsl:value-of select="./@description" />
			</a>
		</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true">&#160;</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@author" /></td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template name="document.link.modified">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<xsl:call-template name="document.outil.zoom" />
		<xsl:call-template name="document.outil.modify.alert" />
		<xsl:call-template name="document.outil.delete.off" />
		<td width="20">&#160;</td>
		<td>
			<a href="{./@url}" target="_blank">
				<img src="{$mediaPath}dochtm.gif" border="0" alt="Ouvrir" title="Ouvrir" />
			</a>
		</td>
		<td class="uportal-channel-strong" nowrap="true">
			<a href="{./@url}" target="_blank">
				<xsl:value-of select="./@description" />
			</a>
		</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true">Modifi</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@author" /></td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		<td width="100%">&#160;</td><td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template name="document.link.deleted">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<xsl:call-template name="document.outil.zoom" />
		<xsl:call-template name="document.outil.modify.off" />
		<xsl:call-template name="document.outil.delete.alert" />
		<td width="20">&#160;</td>
		<td>
			<a href="{./@url}" target="_blank">
				<img src="{$mediaPath}dochtm.gif" border="0" alt="Ouvrir" title="Ouvrir" />
			</a>
		</td>
		<td class="uportal-channel-strong" nowrap="true">
			<a href="{./@url}" target="_blank">
				<xsl:value-of select="./@description" />
			</a>
		</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true">Supprim</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@author" /></td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		<td width="100%">&#160;</td><td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template name="document.link.invalid">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<xsl:call-template name="document.outil.zoom" />
		<xsl:call-template name="document.outil.modify.off" />
		<xsl:call-template name="document.outil.delete" />
		<td width="20">&#160;</td>
		<td>
			<a href="{./@url}" target="_blank">
				<img src="{$mediaPath}dochtm.gif" border="0" alt="Ouvrir" title="Ouvrir" />
			</a>
		</td>
		<td class="uportal-channel-strong" nowrap="true">
			<a href="{./@url}" target="_blank">
				<xsl:value-of select="./@description" />
			</a>
		</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true">Nouveau</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@author" /></td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		<td width="100%">&#160;</td><td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template name="document.link.valid">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<xsl:call-template name="document.outil.zoom" />
		<xsl:call-template name="document.outil.modify" />
		<xsl:call-template name="document.outil.delete" />
		<td width="20">&#160;</td>
		<td>
			<a href="{./@url}" target="_blank">
				<img src="{$mediaPath}dochtm.gif" border="0" alt="Ouvrir" title="Ouvrir" />
			</a>
		</td>
		<td class="uportal-channel-strong" nowrap="true">
			<a href="{./@url}" target="_blank">
				<xsl:value-of select="./@description" />
			</a>
		</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true">&#160;</td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@author" /></td>
		<td width="10">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@datetext" /></td>
		<td width="100%">&#160;</td><td width="100%">&#160;</td>
	</tr>
</xsl:template>

</xsl:stylesheet>