package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.CIntranet.beans.Entity;
import org.esupportail.portal.channels.CIntranet.beans.Group;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.channels.CIntranet.beans.XMLSerializable;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.utils.Groups;
import org.esupportail.portal.utils.Users;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Confirm;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IGroupMember;

/**
 * Population<br>
 * <br>
 * Cette classe gre la population<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class Population extends AbstractAction {

    protected static Log log = LogFactory.getLog(Population.class);
    
    private String intranet = null;
    private List entities = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public Population(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche la population d'un intranet
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Population::init()");
        }
        intranet = getRuntimeData().getParameter("id");
        if(intranet == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        
        DataControler data = new DataControler();
        try {
            entities = data.getIntranetEntities(intranet);
        }
        catch(DataException e) {
            log.error("Population::init() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        for(Iterator i = entities.iterator();i.hasNext();) {
            Entity tmp = (Entity)i.next();
            if(tmp instanceof User) {
                User u = (User)tmp;
                u.setName(Users.getUserDisplayName(u.getId()));
            }
            if(tmp instanceof Group) {
                Group g = (Group)tmp;
                try {
                    g.setName(Groups.getGroupName(g.getId()));
                }
                catch(GroupsException e) {
                    log.error("Population::init() : GroupsException :\n" + e);
                    g.setName("Groupe inconnu");
                }
            }
            
        }
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche la population d'un intranet
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("Population::setXML()");
        }
        Collections.sort(entities);
        StringBuffer xml = new StringBuffer();
        xml.append("<entities>\n");
        for(Iterator i = entities.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</entities>\n");
        if(log.isDebugEnabled()) {
            log.debug("Population::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        return Boolean.TRUE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Ajout d'un groupe
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean addgroupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Population::addgroupinit()");
        }
		Object [] result = mainChannel.getServantResults();
		if(result == null || result.length != 1) {
		    getRuntimeData().setParameter("id", intranet);
			mainChannel.redirect(getRuntimeData(), "population");
			return Boolean.FALSE;
		}
		IGroupMember selected = (IGroupMember)result[0];
		Entity group = new Group();
		group.setId(selected.getKey());
		DataControler data = new DataControler();
		
		if(!entities.contains(group)) {
		    try {
		        data.addIntranetEntity(group, intranet);
		    }
		    catch(DataException e) {
		        log.error("Population::addgroupinit() : DataException :\n" + e);
		        Hashtable parameters = new Hashtable();
		        parameters.put("id", intranet);
				Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "population", parameters);
				return Boolean.FALSE;
		    }
		}
		getRuntimeData().setParameter("id", intranet);
        mainChannel.redirect(runtimeData, "population");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Ajout d'un utilisateur
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean adduserinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Population::adduserinit()");
        }
		Object [] result = mainChannel.getServantResults();
		if(result == null || result.length != 1) {
		    getRuntimeData().setParameter("id", intranet);
			mainChannel.redirect(getRuntimeData(), "population");
			return Boolean.FALSE;
		}
		Personne selected = (Personne)result[0];
		Entity user = new User();
		user.setId(selected.getIdentifiant());
		DataControler data = new DataControler();
		
		if(!entities.contains(user)) {
		    try {
		        data.addIntranetEntity(user, intranet);
		    }
		    catch(DataException e) {
		        log.error("Population::adduserinit() : DataException :\n" + e);
		        Hashtable parameters = new Hashtable();
		        parameters.put("id", intranet);
				Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "population", parameters);
				return Boolean.FALSE;
		    }
		}
		getRuntimeData().setParameter("id", intranet);
        mainChannel.redirect(runtimeData, "population");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Confirmation de suppression d'un groupe
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean delgroupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Population::delgroupinit()");
        }
        String group = getRuntimeData().getParameter("id");
        if(group == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        
        StringBuffer msg = new StringBuffer();
        msg.append("Voulez-vous r\u00E9ellement supprimer ce groupe ?\n");
        msg.append("La suppression des droits et des utilisateurs appartenant \u00E0 ce groupe devra \u00EAtre r\u00E9alis\u00E9e manuellement.");
        Hashtable paramYes = new Hashtable();
        Hashtable paramNo = new Hashtable();
        paramYes.put("group", group);
        paramNo.put("id", intranet);
        Confirm.confirm(getMainChannel(), getRuntimeData(), msg.toString(), "delgroupok", "population", paramYes, paramNo);
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Suppression d'un groupe
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean delgroupokinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Population::delgroupokinit()");
        }
        String group = getRuntimeData().getParameter("group");
        if(group == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        Entity en = new Group();
        en.setId(group);
        DataControler data = new DataControler();
        
        try {
            data.removeIntranetEntity(en, intranet);
        }
        catch(DataException e) {
            
        }
        getRuntimeData().setParameter("id", intranet);
        getMainChannel().redirect(getRuntimeData(), "population");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Confirmation de suppression d'un utilisateur
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean deluserinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Population::deluserinit()");
        }
        String user = getRuntimeData().getParameter("id");
        if(user == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        
        StringBuffer msg = new StringBuffer();
        msg.append("Voulez-vous r\u00E9ellement supprimer cet utilisateur ?\n");
        msg.append("La suppression des droits de cet utilisateur devra \u00EAtre r\u00E9alis\u00E9e manuellement.");
        Hashtable paramYes = new Hashtable();
        Hashtable paramNo = new Hashtable();
        paramYes.put("user", user);
        paramNo.put("id", intranet);
        Confirm.confirm(getMainChannel(), getRuntimeData(), msg.toString(), "deluserok", "population", paramYes, paramNo);
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Suppression d'un utilisateur
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean deluserokinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Population::deluserokinit()");
        }
        String user = getRuntimeData().getParameter("user");
        if(user == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        Entity en = new User();
        en.setId(user);
        DataControler data = new DataControler();
        
        try {
            data.removeIntranetEntity(en, intranet);
        }
        catch(DataException e) {
            
        }
        getRuntimeData().setParameter("id", intranet);
        getMainChannel().redirect(getRuntimeData(), "population");
        return Boolean.FALSE;
    }
}
