package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.beans.SearchResult;
import org.esupportail.portal.channels.CIntranet.beans.XMLSerializable;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.SearchControler;
import org.esupportail.portal.channels.CIntranet.filters.Filter;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.utils.Users;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.ActionParam;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * Search<br>
 * <br>
 * Cette classe prend en charge le moteur de recherche<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class Search extends SubChannel {

    protected static Log log = LogFactory.getLog(Search.class);
    
    private static final int INVALID_SEARCH = 1;
    private static final int PERIMED_SEARCH = 2;
    private static final int LAST_SEARCH = 3;
    private static final int CUSTOM_SEARCH = 4;
    
    private String userid = null;
    private Intranet intranet = null;
    
    private List documents = null;
    private int type = 0;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public Search(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Implmente un comportement par dfaut pour le moteur de recherche
     * @param rd Les runtimeData
     * @return Boolean TRUE si l'utilisateur peut accder au moteur de recherche, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean initialize(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("Search::initialize()");
        }
        userid = getMainChannel().getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
        if(getMainChannel().getStaticData().get("intranet") == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        intranet = (Intranet)getMainChannel().getStaticData().get("intranet");
        try {
            if(!Security.isAdmin(userid)) {
                if(!Security.isIntranetAccessible(userid, intranet.getId())) {
                    Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "intranet");
                    return Boolean.FALSE;
                }
            }
        }
        catch(SecurityException e) {
            log.error("Search::initialize() : SecurityException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche les rsultats d'une recherche
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Search::init()");
        }
        if(documents == null || getRuntimeData().getParameter("new") != null) {
            documents = null;
            getMainChannel().redirect(getRuntimeData(), "search_form");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche les rsultats d'une recherche
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("Search::setXML()");
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<results>\n");
        for(Iterator i = documents.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</results>\n");
        if(log.isDebugEnabled()) {
            log.debug(xml.toString());
        }
        setXML(xml.toString());
        getXSLParameter().put("folder", intranet.getFolder());
        addDownloadXslParameter();
        return Boolean.TRUE;
    }
    
    /**
     * Etape 4/4 du cycle de vie de la SubChannel
     * Choix de la feuille de style fichier/lien
     * Override SubChannel.setOutput() method
     * @throws FrameWorkException
     */
    public void searchoutput() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("Search::searchoutput()");
        }
        Action current = mainChannel.getCurrentAction();
		setSSL(current.getSslFile());
		switch(type) {
			case INVALID_SEARCH: setXSL("invalid_search");break;
			case PERIMED_SEARCH: setXSL("perimed_search");break;
			case LAST_SEARCH : 	 setXSL("last_search");break;
			case CUSTOM_SEARCH :
			default : 			 setXSL("custom_search");break;
		}
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de recherche
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean displayinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Search::displayinit()");
        }
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de recherche
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean displayxml() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("Search::displayxml()");
        }
        setXML("");
        getXSLParameter().put("folder", intranet.getFolder());
        return Boolean.TRUE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Effectue la recherche de documents invalides
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean invalidinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Search::invalidinit()");
        }
        List docs = null;
        SearchControler search = new SearchControler();
        try {
            docs = search.getInvalidDocuments(intranet.getId());
        }
        catch(DataException e) {
            log.error("Search::invalidinit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        try {
            Filter.searchEditorFilter(docs, userid);
        }
        catch(SecurityException e) {
            log.error("Search::invalidinit() : SecurityException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        Collections.sort(docs);
        documents = new ArrayList();
        DataControler data = new DataControler();
        try {
            for(Iterator i = docs.iterator();i.hasNext();) {
                Document doc = (Document)i.next();
                doc.setAuthor(Users.getUserDisplayName(doc.getAuthor()));
                List path = data.getFolderPath(doc.getFolderid());
                SearchResult tmp = new SearchResult();
                tmp.setDocument(doc);
                tmp.setPath(path);
                documents.add(tmp);
            }
        }
        catch(DataException e) {
            log.error("Search::invalidinit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        type = INVALID_SEARCH;
        getMainChannel().redirect(getRuntimeData(), "search");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Effectue la recherche de documents prims
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean perimedinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Search::perimedinit()");
        }
        List docs = null;
        SearchControler search = new SearchControler();
        try {
            docs = search.getPerimedDocuments(intranet.getId());
        }
        catch(DataException e) {
            log.error("Search::perimedinit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        try {
            Filter.searchEditorFilter(docs, userid);
        }
        catch(SecurityException e) {
            log.error("Search::invalidinit() : SecurityException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        Collections.sort(docs);
        documents = new ArrayList();
        DataControler data = new DataControler();
        try {
            for(Iterator i = docs.iterator();i.hasNext();) {
                Document doc = (Document)i.next();
                doc.setAuthor(Users.getUserDisplayName(doc.getAuthor()));
                List path = data.getFolderPath(doc.getFolderid());
                SearchResult tmp = new SearchResult();
                tmp.setDocument(doc);
                tmp.setPath(path);
                documents.add(tmp);
            }
        }
        catch(DataException e) {
            log.error("Search::perimedinit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        type = PERIMED_SEARCH;
        getMainChannel().redirect(getRuntimeData(), "search");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Effectue la recherche des derniers documents dposs
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean lastinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Search::lastinit()");
        }
        ActionParam param = (ActionParam)getMainChannel().getCurrentAction().getParams().get("limit");
        List docs = null;
        SearchControler search = new SearchControler();
        try {
            docs = search.getLastDocuments(intranet.getId(), new Integer(param.getValue()).intValue());
        }
        catch(DataException e) {
            log.error("Search::lastinit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        documents = new ArrayList();
        DataControler data = new DataControler();
        try {
            for(Iterator i = docs.iterator();i.hasNext();) {
                Document doc = (Document)i.next();
                doc.setAuthor(Users.getUserDisplayName(doc.getAuthor()));
                List path = data.getFolderPath(doc.getFolderid());
                SearchResult tmp = new SearchResult();
                tmp.setDocument(doc);
                tmp.setPath(path);
                documents.add(tmp);
            }
        }
        catch(DataException e) {
            log.error("Search::lastinit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        type = LAST_SEARCH;
        getMainChannel().redirect(getRuntimeData(), "search");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Effectue la recherche suivant des critres
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean custominit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("Search::custominit()");
        }
        String doctype = getRuntimeData().getParameter("type");
        String description = getRuntimeData().getParameter("description");
        if(doctype == null || description == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        if(description.equals("")) {
            description = "%";
        }
        else {
            description = "%" + description + "%";
        }
        List docs = null;
        SearchControler search = new SearchControler();
        try {
            docs = search.getCustomDocuments(intranet.getId(), doctype, description);
        }
        catch(DataException e) {
            log.error("Search::custominit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        Collections.sort(docs);
        documents = new ArrayList();
        DataControler data = new DataControler();
        try {
            for(Iterator i = docs.iterator();i.hasNext();) {
                Document doc = (Document)i.next();
                doc.setAuthor(Users.getUserDisplayName(doc.getAuthor()));
                List path = data.getFolderPath(doc.getFolderid());
                SearchResult tmp = new SearchResult();
                tmp.setDocument(doc);
                tmp.setPath(path);
                documents.add(tmp);
            }
        }
        catch(DataException e) {
            log.error("Search::custominit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "search", parameters);
            return Boolean.FALSE;
        }
        type = CUSTOM_SEARCH;
        getMainChannel().redirect(getRuntimeData(), "search");
        return Boolean.FALSE;
    }
}
