package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.RDBMServices;

/**
 * IntranetAccess<br>
 * <br>
 * Ralise les oprations relatives aux intranets dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class IntranetAccess {
    
    protected static Log log = LogFactory.getLog(IntranetAccess.class);
    
    /**
     * Rcupre un intranet 
     * @param query La connexion  utiliser
     * @param id L'identifiant de l'intranet  rcuprer
     * @return intranet L'intranet
     * @throws DataException
     */
    public static Intranet getIntranet(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("IntranetAccess::getIntranet()");
        }
        Intranet intranet = null;
        String sql = "SELECT * FROM INT_INTRANET WHERE ID_INT = '" + id + "'";
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            if(!rs.next()) {
                log.debug("IntranetAccess::getIntranet() : Aucun intranet ayant pour id " + id);
                throw new DataException("Impossible d'acc\u00E9der \u00E0 cet intranet");
            }
            intranet = new Intranet();
            intranet.setId(rs.getString("ID_INT"));
            intranet.setName(rs.getString("NAME_INT"));
            intranet.setOrder(rs.getInt("ORDER_INT"));
            intranet.setFolder(rs.getString("FOL_INT"));
            intranet.setRessource(rs.getString("RES_INT"));
        }
        catch(SQLException e) {
            log.error("IntranetAccess::getIntranet() : " + e);
			log.error("IntranetAccess::getIntranet() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture de l'intranet");
        }
        return intranet;
    }
    
    /**
     * Rcupre tous les intranets
     * @param query La connexion  utiliser
     * @return intranets La liste des intranets
     * @throws DataException
     */
    public static List getIntranets(Query query) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("IntranetAccess::getIntranets()");
        }
        List intranets = new ArrayList();
        String sql = "SELECT * FROM INT_INTRANET";
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            while(rs.next()) {
                Intranet tmp = new Intranet();
                tmp.setId(rs.getString("ID_INT"));
                tmp.setName(rs.getString("NAME_INT"));
                tmp.setOrder(rs.getInt("ORDER_INT"));
                tmp.setFolder(rs.getString("FOL_INT"));
                tmp.setRessource(rs.getString("RES_INT"));
                intranets.add(tmp);
            }
        }
        catch(SQLException e) {
            log.error("IntranetAccess::getIntranets() : " + e);
			log.error("IntranetAccess::getIntranets() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des intranets");
        }
        return intranets;
    }
    
    /**
	 * Cre un intranet
	 * @param query La connexion  utiliser
	 * @param intranet L'intranet  crer
	 */
    public static void createIntranet(Query query, Intranet intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("IntranetAccess::createIntranet()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO INT_INTRANET(ID_INT, NAME_INT, ORDER_INT, RES_INT, ID_DOC, FOL_INT) VALUES(");
        sql.append("'" + intranet.getId() + "', ");
        sql.append("'" + RDBMServices.sqlEscape(intranet.getName()) + "', ");
        sql.append(intranet.getOrder() + ", ");
        sql.append("'" + intranet.getRessource() + "', ");
        sql.append("1, ");
        sql.append(intranet.getFolder() + ")");
        try {
            query.setSql(sql.toString());
            query.insert();
        }
        catch(SQLException e) {
            log.error("IntranetAccess::createIntranet() : " + e);
			log.error("IntranetAccess::createIntranet() : SQL : " + sql);
			throw new DataException("Erreur lors de la cr\u00E9ation de l'intranet");
        }
    }

    /**
     * Met  jour un intranet
     * @param query La connexion  utiliser
     * @param intranet L'intranet  mettre  jour
     * @throws DataException
     */
    public static void updateIntranet(Query query, Intranet intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("IntranetAccess::updateIntranet()");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE INT_INTRANET SET ORDER_INT = ");
        sql.append(intranet.getOrder());
        sql.append(" WHERE ID_INT = '");
        sql.append(intranet.getId());
        sql.append("'");
        try {
            query.setSql(sql.toString());
            query.update();
        }
        catch(SQLException e) {
            log.error("IntranetAccess::updateIntranet() : " + e);
			log.error("IntranetAccess::updateIntranet() : SQL : " + sql);
			throw new DataException("Erreur lors de la mise \u00E0 jour de l'intranet");
        }
    }
    
    /**
	 * Supprime un intranet
	 * @param query La connexion  utiliser
	 * @param id L'identifiant de l'intranet  supprimer
	 * @throws DataException
	 */
    public static void removeIntranet(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("IntranetAccess::removeIntranet()");
        }
        String sql = "DELETE FROM INT_INTRANET WHERE ID_INT = '" + id + "'";
        try {
            query.setSql(sql);
            query.delete();
        }
        catch(SQLException e) {
            log.error("IntranetAccess::removeIntranet() : " + e);
			log.error("IntranetAccess::removeIntranet() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression de l'intranet");
        }
    }

    /**
	 * Teste si un intranet existe dj
	 * @param query La connexion  utiliser
	 * @param id L'identifiant  tester
	 * @return boolean True si l'intranet existe, false sinon
	 * @throws DataException
	 */
    public static boolean intranetExist(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("IntranetAccess::intranetExist()");
        }
        String sql = "SELECT ID_INT FROM INT_INTRANET WHERE ID_INT = '" + id + "'";
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            return rs.next();
        }
        catch(SQLException e) {
            log.error("IntranetAccess::intranetExist() : " + e);
		    log.error("IntranetAccess::intranetExist() : SQL : " + sql);
			throw new DataException("Erreur lors de la v\u00E9rification d'existence");
        }
    }
}
