package org.esupportail.portal.channels.CIntranet.data;

import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.database.Query;

/**
 * OrderAccess<br>
 * <br>
 * Ralise les oprations relatives  l'ordre des documents dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class OrderAccess {
    
    protected static final Log log = LogFactory.getLog(OrderAccess.class);
    
    /**
     * Monte la pile de priorit de 1 rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @throws DataException
     */
    public static void pushDocument(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::pushDocument()");
        }
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = ORDER_DOC + 1 WHERE ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::pushDocument() : " + e);
			log.error("OrderAccess::pushDocument() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
    
    /**
     * Descend la pile de priorit  partir d'un certain rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param order Le rang  partir duquel on travaille
     * @throws DataException
     */
    public static void pullDocument(Query query, String id, int order) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::pullDocument()");
        }
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = ORDER_DOC - 1 WHERE ID_FOL = " + id + " AND ORDER_DOC > " + order;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::pullDocument() : " + e);
			log.error("OrderAccess::pullDocument() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
    
    /**
     * Echange le rang de deux dossiers
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param doc L'identifiant du document
     * @param oldorder L'ancien rang du document
     * @param neworder Le nouveau rang du document
     * @throws DataException
     */
    public static void swapDocument(Query query, String id, String doc, int oldorder, int neworder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::swapDocument()");
        }
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = " + oldorder + " WHERE ORDER_DOC = " + neworder + " AND ID_FOL = " + id;
        try {
            query.setSql(sql);
            query.update();
            sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = " + neworder + " WHERE ID_DOC = '" + doc + "' AND ID_FOL = " + id;
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::swapDocument() : " + e);
			log.error("OrderAccess::swapDocument() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }

    /**
     * Monte la pile de priorit de 1 rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @throws DataException
     */
    public static void pushFolder(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::pushFolder()");
        }
        
        String sql = "UPDATE INT_FOLDER SET ORDER_FOL = ORDER_FOL + 1 WHERE PARENT_FOL = " + id;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::pushFolder() : " + e);
			log.error("OrderAccess::pushFolder() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
    
    /**
     * Descend la pile de priorit  partir d'un certain rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param order Le rang  partir duquel on travaille
     * @throws DataException
     */
    public static void pullFolder(Query query, String id, int order) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::pullFolder()");
        }
        
        String sql = "UPDATE INT_FOLDER SET ORDER_FOL = ORDER_FOL - 1 WHERE PARENT_FOL = " + id + " AND ORDER_FOL > " + order;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::pullFolder() : " + e);
			log.error("OrderAccess::pullFolder() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
    
    /**
     * Echange le rang de deux dossiers
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param id2 L'identifiant du dossier
     * @param oldorder L'ancien rang du document
     * @param neworder Le nouveau rang du document
     * @throws DataException
     */
    public static void swapFolder(Query query, String id, String id2, int oldorder, int neworder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::swapFolder()");
        }
        
        String sql = "UPDATE INT_FOLDER SET ORDER_FOL = " + oldorder + " WHERE ORDER_FOL = " + neworder + " AND PARENT_FOL = " + id;
        try {
            query.setSql(sql);
            query.update();
            sql = "UPDATE INT_FOLDER SET ORDER_FOL = " + neworder + " WHERE ID_FOL = '" + id2 + "' AND PARENT_FOL = " + id;
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::swapFolder() : " + e);
			log.error("OrderAccess::swapFolder() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
    
    /**
     * Monte la pile de priorit de 1 rang
     * @param query La connexion  utiliser
     * @throws DataException
     */
    public static void pushIntranet(Query query) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::pushIntranet()");
        }
        
        String sql = "UPDATE INT_INTRANET SET ORDER_INT = ORDER_INT + 1";
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::pushIntranet() : " + e);
			log.error("OrderAccess::pushIntranet() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
    
    /**
     * Descend la pile de priorit  partir d'un certain rang
     * @param query La connexion  utiliser
     * @param order Le rang  partir duquel on travaille
     * @throws DataException
     */
    public static void pullIntranet(Query query, int order) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::pullIntranet()");
        }
        
        String sql = "UPDATE INT_INTRANET SET ORDER_INT = ORDER_INT - 1 WHERE ORDER_INT > " + order;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::pullIntranet() : " + e);
			log.error("OrderAccess::pullIntranet() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }
    
    /**
     * Echange le rang de deux intranets
     * @param query La connexion  utiliser
     * @param id L'identifiant de l'intranet
     * @param oldorder L'ancien rang du document
     * @param neworder Le nouveau rang du document
     * @throws DataException
     */
    public static void swapIntranet(Query query, String id, int oldorder, int neworder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("OrderAccess::swapIntranet()");
        }
        
        String sql = "UPDATE INT_INTRANET SET ORDER_INT = " + oldorder + " WHERE ORDER_INT = " + neworder;
        try {
            query.setSql(sql);
            query.update();
            sql = "UPDATE INT_INTRANET SET ORDER_INT = " + neworder + " WHERE ID_INT = '" + id + "'";
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("OrderAccess::swapIntranet() : " + e);
			log.error("OrderAccess::swapIntranet() : SQL : " + sql);
			throw new DataException("Erreur lors du changement d'ordre");
        }
    }

}