package org.esupportail.portal.channels.CIntranet.actions.admin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Confirm;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * RemoveIntranet<br>
 * <br>
 * Cette classe gre la suppression d'un intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class RemoveIntranet extends AbstractAction {

    protected static Log log = LogFactory.getLog(RemoveIntranet.class);
    
    private Intranet intranet = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public RemoveIntranet(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche la demande de confirmation de suppression
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("RemoveIntranet::init()");
        }
        String id = getRuntimeData().getParameter("id");
        if(id == null || id.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        DataControler data = new DataControler();
        try {
            intranet = data.getIntranet(id);
        }
        catch(DataException e) {
            log.error("RemoveIntranet::init() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        Confirm.confirm(getMainChannel(), getRuntimeData(), "Voulez-vous r\u00E9ellement supprimer cet intranet ? L'espace de stockage physique devra \u00EAtre supprim\u00E9 manuellement.", "delintranet", "admin");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite la suppression d'un intranet
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean delinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("RemoveIntranet::delinit()");
        }
        DataControler data = new DataControler();
        IStorageControler store = StorageFactory.make(intranet.getRessource());
        try {
            data.removeIntranet(intranet.getId());
            store.destroyIntranet(intranet.getId());
            data.commit();
            data.close();
        }
        catch(DataException e) {
            log.error("RemoveIntranet::delinit() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        catch(StorageException e) {
            log.error("RemoveIntranet::delinit() : StorageException :\n" + e);
            data.rollback();
            data.close();
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        getMainChannel().redirect(getRuntimeData(), "admin");
        return Boolean.FALSE;
    }
}
